/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.AugmentableFeatureVector;
import cc.mallet.types.DenseVector;
import cc.mallet.types.InstanceList;
import cc.mallet.types.LabelVector;
import cc.mallet.types.RankedFeatureVector;
import cc.mallet.types.SparseVector;

public class PartiallyRankedFeatureVector
extends RankedFeatureVector {
    private static final int SORTINIT = -1;
    int numRanked = -1;

    public PartiallyRankedFeatureVector(Alphabet dict, int[] indices, double[] values2) {
        super(dict, indices, values2);
    }

    public PartiallyRankedFeatureVector(Alphabet dict, double[] values2) {
        super(dict, values2);
    }

    public PartiallyRankedFeatureVector(Alphabet dict, DenseVector v) {
        this(dict, v.values);
    }

    public PartiallyRankedFeatureVector(Alphabet dict, AugmentableFeatureVector v) {
        super(dict, v);
    }

    public PartiallyRankedFeatureVector(Alphabet dict, SparseVector v) {
        super(dict, v);
    }

    public int numRanked() {
        if (this.numRanked == -1) {
            this.numRanked = 0;
            for (int i = 0; i < this.values.length; ++i) {
                if (Double.isNaN(this.values[i])) continue;
                ++this.numRanked;
            }
        }
        return this.numRanked;
    }

    @Override
    protected void setRankOrder(int extent, boolean reset2) {
        int sortExtent;
        int n = sortExtent = extent >= this.values.length ? this.values.length - 1 : extent;
        if (sortExtent >= this.numRanked()) {
            return;
        }
        if (this.sortedTo == -1 || reset2) {
            this.rankOrder = new int[this.values.length];
            for (int i = 0; i < this.rankOrder.length; ++i) {
                this.rankOrder[i] = i;
            }
        }
        int i = this.sortedTo + 1;
        while (i <= sortExtent) {
            double front = this.values[this.rankOrder[i]];
            double max2 = Double.isNaN(front) ? Double.NEGATIVE_INFINITY : front;
            int maxIndex = i;
            for (int j = this.sortedTo + 1; j < this.rankOrder.length; ++j) {
                double next2 = this.values[this.rankOrder[j]];
                if (Double.isNaN(next2) || !(next2 > max2)) continue;
                max2 = next2;
                maxIndex = j;
            }
            int r = this.rankOrder[maxIndex];
            this.rankOrder[maxIndex] = this.rankOrder[i];
            this.rankOrder[i] = r;
            this.sortedTo = i++;
        }
    }

    public static interface PerLabelFactory {
        public PartiallyRankedFeatureVector[] newPartiallyRankedFeatureVectors(InstanceList var1, LabelVector[] var2);
    }

    public static interface Factory {
        public PartiallyRankedFeatureVector newPartiallyRankedFeatureVector(InstanceList var1, LabelVector[] var2);
    }
}

