/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.pipe.Noop;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.MatrixOps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.dgc.VMID;
import java.util.BitSet;
import java.util.Random;

public class PagedInstanceList
extends InstanceList {
    private static final char TYPE_FEATURE_VECTOR = 'F';
    private static final char TYPE_LABEL = 'L';
    private static final char TYPE_OBJECT = 'O';
    int instancesPerPage;
    File swapDir;
    int[] inMemoryPageIds;
    InstanceList[] inMemoryPages;
    BitSet dirty = new BitSet();
    int size = 0;
    boolean collectGarbage = true;
    int swapIns = 0;
    long swapInTime = 0L;
    int swapOuts = 0;
    long swapOutTime = 0L;
    VMID id = new VMID();
    Pipe noopPipe;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public PagedInstanceList(Pipe pipe, int numPages, int instancesPerPage, File swapDir) {
        super(pipe, numPages * instancesPerPage);
        this.instancesPerPage = instancesPerPage;
        this.swapDir = swapDir;
        this.inMemoryPageIds = new int[numPages];
        this.inMemoryPages = new InstanceList[numPages];
        this.noopPipe = new Noop(pipe.getDataAlphabet(), pipe.getTargetAlphabet());
        for (int i = 0; i < numPages; ++i) {
            this.inMemoryPageIds[i] = -1;
        }
        try {
            if (!swapDir.exists()) {
                swapDir.mkdir();
            }
        }
        catch (SecurityException e) {
            System.err.println("No permission to make directory " + swapDir);
            System.exit(-1);
        }
    }

    public PagedInstanceList(Pipe pipe, int numPages, int instancesPerPage) {
        this(pipe, numPages, instancesPerPage, new File("."));
    }

    private void shuffleArray(Random r, int[] a) {
        int size2 = a.length;
        for (int i = size2 - 1; i > 0; --i) {
            int swap = r.nextInt(i + 1);
            int tmp = a[i];
            a[i] = a[swap];
            a[swap] = tmp;
        }
    }

    @Override
    public InstanceList[] split(Random r, double[] proportions) {
        int i;
        InstanceList[] ret = new InstanceList[proportions.length];
        double[] maxind = (double[])proportions.clone();
        int size2 = this.size();
        int[] shuffled = new int[size2];
        int[] splits = new int[size2];
        for (i = 0; i < size2; ++i) {
            shuffled[i] = i;
        }
        this.shuffleArray(r, shuffled);
        MatrixOps.normalize(maxind);
        for (i = 0; i < maxind.length; ++i) {
            ret[i] = this.cloneEmpty();
            if (i <= 0) continue;
            int n = i;
            maxind[n] = maxind[n] + maxind[i - 1];
        }
        for (i = 0; i < maxind.length; ++i) {
            maxind[i] = Math.rint(maxind[i] * (double)size2);
        }
        int j = 0;
        for (i = 0; i < size2; ++i) {
            while ((double)i >= maxind[j] && j < ret.length) {
                ++j;
            }
            splits[shuffled[i]] = j;
        }
        for (i = 0; i < size2; ++i) {
            ret[splits[i]].add(this.get(i));
        }
        return ret;
    }

    private File getFileForPage(int page) {
        return new File(this.swapDir, this.id + "." + page);
    }

    private InstanceList getPageForIndex(int index, boolean dirty) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.swapIn(index / this.instancesPerPage, dirty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstanceList swapIn(int pageId, boolean dirty) {
        int bin = pageId % this.inMemoryPages.length;
        if (this.inMemoryPageIds[bin] != pageId) {
            this.swapOut(this.inMemoryPageIds[bin]);
            long startTime = System.currentTimeMillis();
            File pageFile = this.getFileForPage(pageId);
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(new FileInputStream(pageFile));
                InstanceList page = this.deserializePage(in);
                this.inMemoryPageIds[bin] = pageId;
                this.inMemoryPages[bin] = page;
            }
            catch (Exception e) {
                System.err.println(e);
                System.exit(-1);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        System.exit(-1);
                    }
                }
            }
            ++this.swapIns;
            this.swapInTime += System.currentTimeMillis() - startTime;
        }
        if (dirty) {
            this.dirty.set(bin);
        }
        return this.inMemoryPages[bin];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapOut(int pageId) {
        int bin = pageId % this.inMemoryPages.length;
        if (pageId != -1 && this.dirty.get(bin)) {
            long startTime = System.currentTimeMillis();
            File pageFile = this.getFileForPage(pageId);
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(new FileOutputStream(pageFile));
                InstanceList page = this.inMemoryPages[bin];
                this.inMemoryPageIds[bin] = -1;
                this.inMemoryPages[bin] = null;
                this.serializePage(out, page);
                this.dirty.set(bin, false);
            }
            catch (Exception e) {
                System.err.println(e);
                System.exit(-1);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        System.exit(-1);
                    }
                }
            }
            if (this.collectGarbage) {
                System.gc();
            }
            ++this.swapOuts;
            this.swapOutTime += System.currentTimeMillis() - startTime;
        }
    }

    @Override
    public boolean add(Instance instance) {
        InstanceList page;
        if (this.size % this.instancesPerPage == 0) {
            int pageId = this.size / this.instancesPerPage;
            int bin = pageId % this.inMemoryPages.length;
            this.swapOut(this.inMemoryPageIds[bin]);
            page = new InstanceList(this.noopPipe);
            this.inMemoryPageIds[bin] = pageId;
            this.inMemoryPages[bin] = page;
        } else {
            page = this.getPageForIndex(this.size, true);
        }
        boolean ret = page.add(instance);
        if (ret) {
            ++this.size;
        }
        return ret;
    }

    @Override
    public Instance get(int index) {
        InstanceList page = this.getPageForIndex(index, false);
        return (Instance)page.get(index % this.instancesPerPage);
    }

    @Override
    public Instance set(int index, Instance instance) {
        InstanceList page = this.getPageForIndex(index, true);
        return page.set(index % this.instancesPerPage, instance);
    }

    public boolean getCollectGarbage() {
        return this.collectGarbage;
    }

    public void setCollectGarbage(boolean b) {
        this.collectGarbage = b;
    }

    @Override
    public InstanceList shallowClone() {
        InstanceList ret = this.cloneEmpty();
        for (int i = 0; i < this.size(); ++i) {
            ret.add(this.get(i));
        }
        return ret;
    }

    @Override
    public InstanceList cloneEmpty() {
        return super.cloneEmptyInto(new PagedInstanceList(this.pipe, this.inMemoryPages.length, this.instancesPerPage, this.swapDir));
    }

    @Override
    public void clear() {
        int i;
        int numPages = this.size / this.instancesPerPage;
        for (i = 0; i <= numPages; ++i) {
            this.getFileForPage(i).delete();
        }
        for (i = 0; i < this.inMemoryPages.length; ++i) {
            this.inMemoryPages[i] = null;
            this.inMemoryPageIds[i] = -1;
        }
        this.size = 0;
        this.swapIns = 0;
        this.swapInTime = 0L;
        this.swapOuts = 0;
        this.swapOutTime = 0L;
        this.dirty.clear();
        super.clear();
    }

    public int getSwapIns() {
        return this.swapIns;
    }

    public long getSwapInTime() {
        return this.swapInTime;
    }

    public int getSwapOuts() {
        return this.swapOuts;
    }

    public long getSwapOutTime() {
        return this.swapOutTime;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void serializeObject(ObjectOutputStream out, Object obj) throws IOException {
        if (obj instanceof FeatureVector) {
            FeatureVector features = (FeatureVector)obj;
            out.writeChar(70);
            out.writeObject(features.getIndices());
            out.writeObject(features.getValues());
        } else if (obj instanceof Label) {
            out.writeChar(76);
            out.writeObject(((Label)obj).toString());
        } else {
            out.writeChar(79);
            out.writeObject(obj);
        }
    }

    private void serializePage(ObjectOutputStream out, InstanceList page) throws IOException {
        out.writeInt(page.size());
        for (Instance inst : page) {
            this.serializeObject(out, inst.getData());
            this.serializeObject(out, inst.getTarget());
            out.writeObject(inst.getName());
            out.writeObject(inst.getSource());
            if (this.instWeights != null) {
                Double weight = (Double)this.instWeights.get(inst);
                if (weight != null) {
                    out.writeDouble((Double)this.instWeights.get(inst));
                    continue;
                }
                out.writeDouble(1.0);
                continue;
            }
            out.writeDouble(1.0);
        }
    }

    private Object deserializeObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object obj;
        char type = in.readChar();
        switch (type) {
            case 'L': {
                LabelAlphabet ldict = (LabelAlphabet)this.getTargetAlphabet();
                String name = (String)in.readObject();
                obj = ldict.lookupLabel(name);
                break;
            }
            case 'F': {
                int[] indices = (int[])in.readObject();
                double[] values2 = (double[])in.readObject();
                obj = new FeatureVector(this.getDataAlphabet(), indices, values2);
                break;
            }
            case 'O': {
                obj = in.readObject();
                break;
            }
            default: {
                throw new IOException("Unknown object type " + type);
            }
        }
        return obj;
    }

    private InstanceList deserializePage(ObjectInputStream in) throws IOException, ClassNotFoundException {
        InstanceList page = new InstanceList(this.noopPipe);
        int size2 = in.readInt();
        for (int i = 0; i < size2; ++i) {
            Object data2 = this.deserializeObject(in);
            Object target = this.deserializeObject(in);
            Object name = in.readObject();
            Object source = in.readObject();
            double weight = in.readDouble();
            page.add(new Instance(data2, target, name, source), weight);
        }
        return page;
    }

    public static InstanceList load(File file) {
        try {
            ObjectInputStream ois = file.toString().equals("-") ? new ObjectInputStream(System.in) : new ObjectInputStream(new FileInputStream(file));
            PagedInstanceList ilist = (PagedInstanceList)ois.readObject();
            ois.close();
            return ilist;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Couldn't read PagedInstanceList from file " + file);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.id);
        out.writeObject(this.pipe);
        out.writeInt(this.instancesPerPage);
        out.writeObject(this.swapDir);
        out.writeObject(this.inMemoryPageIds);
        out.writeObject(this.dirty);
        for (int i = 0; i < this.inMemoryPages.length; ++i) {
            this.serializePage(out, this.inMemoryPages[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.id = (VMID)in.readObject();
        this.pipe = (Pipe)in.readObject();
        this.instancesPerPage = in.readInt();
        this.swapDir = (File)in.readObject();
        this.inMemoryPageIds = (int[])in.readObject();
        this.dirty = (BitSet)in.readObject();
        this.inMemoryPages = new InstanceList[this.inMemoryPageIds.length];
        for (int i = 0; i < this.inMemoryPageIds.length; ++i) {
            this.inMemoryPages[i] = this.deserializePage(in);
        }
    }
}

