/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class MultiInstanceList
extends InstanceList {
    private static final long serialVersionUID = -7177121200386974657L;
    private static final InstanceList[] EMPTY_ARRAY = new InstanceList[0];
    private final InstanceList[] lists;
    private final int[] offsets;

    public MultiInstanceList(InstanceList[] lists) {
        super(lists[0].getPipe());
        this.lists = lists;
        this.offsets = new int[lists.length];
        int offset = 0;
        for (int i = 0; i < lists.length; ++i) {
            this.offsets[i] = offset;
            offset += lists[i].size();
            if (lists[i].instWeights == null) continue;
            if (this.instWeights == null) {
                this.instWeights = new HashMap();
            }
            this.instWeights.putAll(this.instWeights);
        }
    }

    public MultiInstanceList(List<InstanceList> lists) {
        this(lists.toArray(EMPTY_ARRAY));
    }

    @Override
    public boolean add(Instance instance, double instanceWeight) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Instance instance) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Instance element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() {
        InstanceList[] newLists = new InstanceList[this.lists.length];
        for (int i = 0; i < this.lists.length; ++i) {
            newLists[i] = (InstanceList)this.lists[i].clone();
        }
        return new MultiInstanceList(newLists);
    }

    @Override
    public InstanceList cloneEmpty() {
        InstanceList[] newLists = new InstanceList[this.lists.length];
        for (int i = 0; i < this.lists.length; ++i) {
            newLists[i] = this.lists[i].cloneEmpty();
        }
        return new MultiInstanceList(newLists);
    }

    @Override
    protected InstanceList cloneEmptyInto(InstanceList ret) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object elem2) {
        for (InstanceList list2 : this.lists) {
            if (list2 == null || !list2.contains(elem2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public InstanceList.CrossValidationIterator crossValidationIterator(int nfolds, int seed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InstanceList.CrossValidationIterator crossValidationIterator(int nfolds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MultiInstanceList) {
            MultiInstanceList tmp = (MultiInstanceList)o;
            if (tmp.lists.length != this.lists.length) {
                return false;
            }
            for (int i = 0; i < this.lists.length; ++i) {
                InstanceList thisList = this.lists[i];
                InstanceList tmpList = tmp.lists[i];
                if (thisList == null && tmpList != null) {
                    return false;
                }
                if (thisList.equals(tmpList)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Instance get(int index) {
        int i = this.getOffsetIndex(index);
        return (Instance)this.lists[i].get(index - this.offsets[i]);
    }

    private int getOffsetIndex(int index) {
        int i = Arrays.binarySearch(this.offsets, index);
        if (i < 0) {
            i = -i - 2;
        }
        return i;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (InstanceList list2 : this.lists) {
            hashCode = 31 * hashCode + (list2 == null ? 0 : list2.hashCode());
        }
        return hashCode;
    }

    @Override
    public int indexOf(Object elem2) {
        for (int i = 0; i < this.lists.length; ++i) {
            int index = this.lists[i].indexOf(elem2);
            if (index == -1) continue;
            return index + this.offsets[i];
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        for (InstanceList list2 : this.lists) {
            if (list2 == null || list2.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Instance> iterator() {
        return new MultiIterator();
    }

    @Override
    public int lastIndexOf(Object elem2) {
        for (int i = this.lists.length - 1; i >= 0; --i) {
            int index = this.lists[i].lastIndexOf(elem2);
            if (index == -1) continue;
            return index + this.offsets[i];
        }
        return -1;
    }

    @Override
    public ListIterator<Instance> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Instance> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Instance instance) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Instance remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Instance set(int index, Instance instance) {
        int i = this.getOffsetIndex(index);
        return this.lists[i].set(index - this.offsets[i], instance);
    }

    @Override
    public void setInstance(int index, Instance instance) {
        int i = this.getOffsetIndex(index);
        this.lists[i].setInstance(index - this.offsets[i], instance);
    }

    @Override
    public void setInstanceWeight(Instance instance, double weight) {
        super.setInstanceWeight(instance, weight);
        int index = this.indexOf(instance);
        int i = this.getOffsetIndex(index);
        this.lists[i].setInstanceWeight(index - this.offsets[i], weight);
    }

    @Override
    public InstanceList shallowClone() {
        InstanceList[] newLists = new InstanceList[this.lists.length];
        for (int i = 0; i < this.lists.length; ++i) {
            newLists[i] = this.lists[i].shallowClone();
        }
        return new MultiInstanceList(newLists);
    }

    @Override
    public void shuffle(Random r) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int size2 = 0;
        for (InstanceList list2 : this.lists) {
            if (list2 == null) continue;
            size2 += list2.size();
        }
        return size2;
    }

    @Override
    public InstanceList[] split(double[] proportions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InstanceList[] split(Random r, double[] proportions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InstanceList[] splitInOrder(double[] proportions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InstanceList[] splitInOrder(int[] counts) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InstanceList[] splitInTwoByModulo(int m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InstanceList subList(double proportion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InstanceList subList(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        Object[] result2 = new Object[this.size()];
        int i = 0;
        for (InstanceList list2 : this.lists) {
            if (list2 == null) continue;
            for (Instance instance : list2) {
                result2[i++] = instance;
            }
        }
        return result2;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size2 = this.size();
        if (a.length < size2) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size2);
        }
        T[] result2 = a;
        int i = 0;
        for (InstanceList list2 : this.lists) {
            if (list2 == null) continue;
            for (Instance instance : list2) {
                result2[i++] = instance;
            }
        }
        if (a.length > size2) {
            a[size2] = null;
        }
        return a;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int listIndex = 0; listIndex < this.lists.length; ++listIndex) {
            if (this.lists[listIndex] == null) continue;
            Iterator i = this.lists[listIndex].iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                Instance o = (Instance)i.next();
                buf.append(String.valueOf(o));
                hasNext = i.hasNext();
                if (listIndex >= this.lists.length && !hasNext) continue;
                buf.append(", ");
            }
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public void trimToSize() {
        for (InstanceList list2 : this.lists) {
            list2.trimToSize();
        }
    }

    private class MultiIterator
    implements Iterator<Instance>,
    Serializable {
        private static final long serialVersionUID = -2446488635289279133L;
        int index = 0;
        Iterator<Instance> i;

        public MultiIterator() {
            this.i = MultiInstanceList.this.lists.length == 0 ? null : MultiInstanceList.this.lists[0].iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.index < MultiInstanceList.this.lists.length) {
                if (this.i.hasNext()) {
                    return true;
                }
                for (int tmpIndex = this.index + 1; tmpIndex < MultiInstanceList.this.lists.length; ++tmpIndex) {
                    InstanceList list2 = MultiInstanceList.this.lists[tmpIndex];
                    if (list2 == null || MultiInstanceList.this.lists[tmpIndex].size() <= 0) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Instance next() {
            if (this.index < MultiInstanceList.this.lists.length) {
                if (this.i.hasNext()) {
                    return this.i.next();
                }
                ++this.index;
                while (this.index < MultiInstanceList.this.lists.length) {
                    InstanceList list2 = MultiInstanceList.this.lists[this.index];
                    if (list2 != null && MultiInstanceList.this.lists[this.index].size() > 0) {
                        this.i = MultiInstanceList.this.lists[this.index].iterator();
                        return this.i.next();
                    }
                    ++this.index;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

