/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.AlphabetCarrying;
import cc.mallet.types.Label;
import cc.mallet.types.LabelSequence;
import cc.mallet.types.Labels;
import cc.mallet.types.Sequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class LabelsSequence
implements Sequence,
AlphabetCarrying,
Serializable {
    Labels[] seq;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public LabelsSequence(Labels[] seq2) {
        for (int i = 0; i < seq2.length - 1; ++i) {
            if (Alphabet.alphabetsMatch(seq2[i], seq2[i + 1])) continue;
            throw new IllegalArgumentException("Alphabets do not match");
        }
        this.seq = new Labels[seq2.length];
        System.arraycopy(seq2, 0, this.seq, 0, seq2.length);
    }

    public LabelsSequence(LabelSequence seq2) {
        this.seq = new Labels[seq2.size()];
        for (int i = 0; i < seq2.length; ++i) {
            this.seq[i] = new Labels(new Label[]{seq2.getLabelAtPosition(i)});
        }
    }

    @Override
    public Alphabet getAlphabet() {
        return this.seq[0].getAlphabet();
    }

    @Override
    public Alphabet[] getAlphabets() {
        return this.seq[0].getAlphabets();
    }

    @Override
    public int size() {
        return this.seq.length;
    }

    public Object get(int i) {
        return this.seq[i];
    }

    public Labels getLabels(int i) {
        return this.seq[i];
    }

    public String toString() {
        String ret = "LabelsSequence:\n";
        for (int i = 0; i < this.seq.length; ++i) {
            ret = ret + i + ": ";
            ret = ret + this.seq[i].toString();
            ret = ret + "\n";
        }
        return ret;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        in.defaultReadObject();
    }
}

