/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.AlphabetCarrying;
import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Alphabet
implements Serializable {
    TObjectIntHashMap map;
    ArrayList entries;
    boolean growthStopped = false;
    Class entryClass = null;
    VMID instanceId = new VMID();
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;
    private static transient HashMap deserializedEntries = new HashMap();

    public Alphabet(int capacity, Class entryClass) {
        this.map = new TObjectIntHashMap(capacity);
        this.entries = new ArrayList(capacity);
        this.entryClass = entryClass;
        deserializedEntries.put(this.instanceId, this);
    }

    public Alphabet(Class entryClass) {
        this(8, entryClass);
    }

    public Alphabet(int capacity) {
        this(capacity, null);
    }

    public Alphabet() {
        this(8, null);
    }

    public Alphabet(Object[] entries) {
        this(entries.length);
        for (Object entry : entries) {
            this.lookupIndex(entry);
        }
    }

    public Object clone() {
        Alphabet ret = new Alphabet();
        ret.map = this.map.clone();
        ret.entries = (ArrayList)this.entries.clone();
        ret.growthStopped = this.growthStopped;
        ret.entryClass = this.entryClass;
        return ret;
    }

    public int lookupIndex(Object entry, boolean addIfNotPresent) {
        if (entry == null) {
            throw new IllegalArgumentException("Can't lookup \"null\" in an Alphabet.");
        }
        if (this.entryClass == null) {
            this.entryClass = entry.getClass();
        } else if (entry.getClass() != this.entryClass) {
            throw new IllegalArgumentException("Non-matching entry class, " + entry.getClass() + ", was " + this.entryClass);
        }
        int retIndex = -1;
        if (this.map.containsKey(entry)) {
            retIndex = this.map.get(entry);
        } else if (!this.growthStopped && addIfNotPresent) {
            retIndex = this.entries.size();
            this.map.put(entry, retIndex);
            this.entries.add(entry);
        }
        return retIndex;
    }

    public int lookupIndex(Object entry) {
        return this.lookupIndex(entry, true);
    }

    public Object lookupObject(int index) {
        return this.entries.get(index);
    }

    public Object[] toArray() {
        return this.entries.toArray();
    }

    public Object[] toArray(Object[] in) {
        return this.entries.toArray(in);
    }

    public Iterator iterator() {
        return this.entries.iterator();
    }

    public Object[] lookupObjects(int[] indices) {
        Object[] ret = new Object[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = this.entries.get(indices[i]);
        }
        return ret;
    }

    public Object[] lookupObjects(int[] indices, Object[] buf) {
        for (int i = 0; i < indices.length; ++i) {
            buf[i] = this.entries.get(indices[i]);
        }
        return buf;
    }

    public int[] lookupIndices(Object[] objects, boolean addIfNotPresent) {
        int[] ret = new int[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            ret[i] = this.lookupIndex(objects[i], addIfNotPresent);
        }
        return ret;
    }

    public boolean contains(Object entry) {
        return this.map.contains(entry);
    }

    public int size() {
        return this.entries.size();
    }

    public void stopGrowth() {
        this.growthStopped = true;
    }

    public void startGrowth() {
        this.growthStopped = false;
    }

    public boolean growthStopped() {
        return this.growthStopped;
    }

    public Class entryClass() {
        return this.entryClass;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.entries.size(); ++i) {
            sb.append(this.entries.get(i).toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream out) {
        this.dump(new PrintWriter((Writer)new OutputStreamWriter(out), true));
    }

    public void dump(PrintWriter out) {
        for (int i = 0; i < this.entries.size(); ++i) {
            out.println(i + " => " + this.entries.get(i));
        }
    }

    public static boolean alphabetsMatch(AlphabetCarrying object1, AlphabetCarrying object2) {
        Alphabet[] a2;
        Alphabet[] a1 = object1.getAlphabets();
        if (a1.length != (a2 = object2.getAlphabets()).length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            if (a1[i] == null || a2[i] == null) {
                return false;
            }
            if (a1[i].equals(a2[i])) continue;
            return false;
        }
        return true;
    }

    public VMID getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(VMID id) {
        this.instanceId = id;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeInt(this.entries.size());
        for (int i = 0; i < this.entries.size(); ++i) {
            out.writeObject(this.entries.get(i));
        }
        out.writeBoolean(this.growthStopped);
        out.writeObject(this.entryClass);
        out.writeObject(this.instanceId);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        int size2 = in.readInt();
        this.entries = new ArrayList(size2);
        this.map = new TObjectIntHashMap(size2);
        for (int i = 0; i < size2; ++i) {
            Object o = in.readObject();
            this.map.put(o, i);
            this.entries.add(o);
        }
        this.growthStopped = in.readBoolean();
        this.entryClass = (Class)in.readObject();
        if (version > 0) {
            this.instanceId = (VMID)in.readObject();
        }
    }

    public Object readResolve() throws ObjectStreamException {
        Object previous = deserializedEntries.get(this.instanceId);
        if (previous != null) {
            return previous;
        }
        if (this.instanceId != null) {
            deserializedEntries.put(this.instanceId, this);
        }
        return this;
    }
}

