/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.share.upenn.ner;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.Serializable;
import java.util.regex.Pattern;

public class LongRegexMatches
extends Pipe
implements Serializable {
    String name;
    Pattern regex;
    int min;
    int max;

    public LongRegexMatches(String featureName, Pattern regex, int min2, int max2) {
        this.name = featureName;
        this.regex = regex;
        this.min = min2;
        this.max = max2;
    }

    @Override
    public Instance pipe(Instance carrier) {
        int i;
        TokenSequence ts = (TokenSequence)carrier.getData();
        boolean[] marked = new boolean[ts.size()];
        for (i = 0; i < ts.size(); ++i) {
            int loc;
            StringBuffer sb = new StringBuffer();
            for (int length = 1; length <= this.max && (loc = i - length + 1) >= 0; ++length) {
                sb.insert(0, ((Token)ts.get(loc)).getText());
                if (length < this.min || !this.regex.matcher(sb.toString()).matches()) continue;
                for (int j = 0; j < length; ++j) {
                    marked[loc + j] = true;
                }
            }
        }
        for (i = 0; i < ts.size(); ++i) {
            if (!marked[i]) continue;
            ((Token)ts.get(i)).setFeatureValue(this.name, 1.0);
        }
        return carrier;
    }
}

