/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.share.upenn.ner;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import cc.mallet.util.PropertyList;
import gnu.trove.TObjectDoubleHashMap;
import java.io.Serializable;

public class FeatureWindow
extends Pipe
implements Serializable {
    int left;
    int right;

    public FeatureWindow(int left, int right) {
        assert (left >= 0 && right >= 0);
        this.left = left;
        this.right = right;
    }

    @Override
    public Instance pipe(Instance carrier) {
        int i;
        TokenSequence seq2 = (TokenSequence)carrier.getData();
        TObjectDoubleHashMap[] original = new TObjectDoubleHashMap[seq2.size()];
        for (i = 0; i < seq2.size(); ++i) {
            Token t = (Token)seq2.get(i);
            original[i] = new TObjectDoubleHashMap();
            PropertyList.Iterator pl = t.getFeatures().iterator();
            while (pl.hasNext()) {
                pl.nextProperty();
                original[i].put(pl.getKey(), pl.getNumericValue());
            }
        }
        for (i = 0; i < original.length; ++i) {
            for (int j = -1 * this.left; j <= this.right; ++j) {
                String append2;
                int index = i + j;
                String string2 = append2 = j < 0 ? "/" + j : "/+" + j;
                if (index < 0 || index == i || index >= original.length) continue;
                Token t = (Token)seq2.get(i);
                Object[] features = original[index].keys();
                for (int k = 0; k < features.length; ++k) {
                    t.setFeatureValue((String)features[k] + append2, original[index].get(features[k]));
                }
            }
        }
        return carrier;
    }
}

