/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.FeatureVectorSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.Sequence;
import cc.mallet.types.TokenSequence;
import cc.mallet.util.Maths;
import java.io.PrintWriter;

public class SequencePrintingPipe
extends Pipe {
    private PrintWriter writer;

    public SequencePrintingPipe(PrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public Instance pipe(Instance carrier) {
        Sequence data2 = (Sequence)carrier.getData();
        Sequence target = (Sequence)carrier.getTarget();
        if (data2.size() != target.size()) {
            throw new IllegalArgumentException("Trying to print into SimpleTagger format, where data and target lengths do not match\ndata.length = " + data2.size() + ", target.length = " + target.size());
        }
        int N = data2.size();
        if (data2 instanceof TokenSequence) {
            throw new UnsupportedOperationException("Not yet implemented.");
        }
        if (data2 instanceof FeatureVectorSequence) {
            FeatureVectorSequence fvs = (FeatureVectorSequence)data2;
            Alphabet dict = fvs.size() > 0 ? fvs.getFeatureVector(0).getAlphabet() : null;
            for (int i = 0; i < N; ++i) {
                Object label = target.get(i);
                this.writer.print(label);
                FeatureVector fv = fvs.getFeatureVector(i);
                for (int loc = 0; loc < fv.numLocations(); ++loc) {
                    this.writer.print(' ');
                    String fname = dict.lookupObject(fv.indexAtLocation(loc)).toString();
                    double value2 = fv.valueAtLocation(loc);
                    if (!Maths.almostEquals(value2, 1.0)) {
                        throw new IllegalArgumentException("Printing to SimpleTagger format: FeatureVector not binary at time slice " + i + " fv:" + fv);
                    }
                    this.writer.print(fname);
                }
                this.writer.println();
            }
        } else {
            throw new IllegalArgumentException("Don't know how to print data of type " + data2);
        }
        this.writer.println();
        return carrier;
    }
}

