/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TokenSequenceParseFeatureString
extends Pipe
implements Serializable {
    boolean realValued;
    boolean specifyFeatureNames;
    String nameValueSeparator;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public TokenSequenceParseFeatureString(boolean _realValued, boolean _specifyFeatureNames, String _nameValueSeparator) {
        this.realValued = _realValued;
        if (_nameValueSeparator.trim().length() == 0) {
            throw new IllegalArgumentException("nameValueSeparator can't be whitespace");
        }
        this.nameValueSeparator = _nameValueSeparator;
        this.specifyFeatureNames = _specifyFeatureNames;
    }

    public TokenSequenceParseFeatureString(boolean _realValued, boolean _specifyFeatureNames) {
        this(_realValued, _specifyFeatureNames, "=");
    }

    public TokenSequenceParseFeatureString(boolean _realValued) {
        this(_realValued, false, "=");
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        for (int i = 0; i < ts.size(); ++i) {
            Token t = (Token)ts.get(i);
            String[] values2 = t.getText().split("\\s+");
            for (int j = 0; j < values2.length; ++j) {
                if (this.specifyFeatureNames) {
                    String[] nameAndValue = values2[j].split(this.nameValueSeparator);
                    if (nameAndValue.length != 2) {
                        t.setFeatureValue("Token=" + values2[j], 1.0);
                        continue;
                    }
                    t.setFeatureValue(nameAndValue[0], Double.parseDouble(nameAndValue[1]));
                    continue;
                }
                if (this.realValued) {
                    t.setFeatureValue("Feature#" + j, Double.parseDouble(values2[j]));
                    continue;
                }
                t.setFeatureValue(values2[j], 1.0);
            }
        }
        carrier.setData(ts);
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeBoolean(this.realValued);
        out.writeBoolean(this.specifyFeatureNames);
        out.writeObject(this.nameValueSeparator);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.realValued = in.readBoolean();
        if (version >= 1) {
            this.specifyFeatureNames = in.readBoolean();
            this.nameValueSeparator = (String)in.readObject();
        }
    }
}

