/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.optimize;

import cc.mallet.optimize.BackTrackLineSearch;
import cc.mallet.optimize.InvalidOptimizableException;
import cc.mallet.optimize.LineOptimizer;
import cc.mallet.optimize.Optimizable;
import cc.mallet.optimize.OptimizationException;
import cc.mallet.optimize.Optimizer;
import cc.mallet.optimize.OptimizerEvaluator;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.MalletLogger;
import java.util.LinkedList;
import java.util.logging.Logger;

public class LimitedMemoryBFGS
implements Optimizer {
    private static Logger logger = MalletLogger.getLogger("edu.umass.cs.mallet.base.ml.maximize.LimitedMemoryBFGS");
    boolean converged = false;
    Optimizable.ByGradientValue optimizable;
    final int maxIterations = 1000;
    private double tolerance = 1.0E-4;
    final double gradientTolerance = 0.001;
    final double eps = 1.0E-5;
    final int m = 4;
    private LineOptimizer.ByGradient lineMaximizer;
    double[] g;
    double[] oldg;
    double[] direction;
    double[] parameters;
    double[] oldParameters;
    LinkedList s = new LinkedList();
    LinkedList y = new LinkedList();
    LinkedList rho = new LinkedList();
    double[] alpha;
    static double step = 1.0;
    int iterations;
    private OptimizerEvaluator.ByGradient eval = null;

    public LimitedMemoryBFGS(Optimizable.ByGradientValue function) {
        this.optimizable = function;
        this.lineMaximizer = new BackTrackLineSearch(function);
    }

    @Override
    public Optimizable getOptimizable() {
        return this.optimizable;
    }

    @Override
    public boolean isConverged() {
        return this.converged;
    }

    public void setLineOptimizer(LineOptimizer.ByGradient lineOpt) {
        this.lineMaximizer = lineOpt;
    }

    public void setTolerance(double newtol) {
        this.tolerance = newtol;
    }

    public void setEvaluator(OptimizerEvaluator.ByGradient eval) {
        this.eval = eval;
    }

    public int getIteration() {
        return this.iterations;
    }

    @Override
    public boolean optimize() {
        return this.optimize(Integer.MAX_VALUE);
    }

    @Override
    public boolean optimize(int numIterations) {
        double initialValue = this.optimizable.getValue();
        logger.fine("Entering L-BFGS.optimize(). Initial Value=" + initialValue);
        if (this.g == null) {
            logger.fine("First time through L-BFGS");
            this.iterations = 0;
            this.s = new LinkedList();
            this.y = new LinkedList();
            this.rho = new LinkedList();
            this.alpha = new double[4];
            for (int i = 0; i < 4; ++i) {
                this.alpha[i] = 0.0;
            }
            this.parameters = new double[this.optimizable.getNumParameters()];
            this.oldParameters = new double[this.optimizable.getNumParameters()];
            this.g = new double[this.optimizable.getNumParameters()];
            this.oldg = new double[this.optimizable.getNumParameters()];
            this.direction = new double[this.optimizable.getNumParameters()];
            this.optimizable.getParameters(this.parameters);
            System.arraycopy(this.parameters, 0, this.oldParameters, 0, this.parameters.length);
            this.optimizable.getValueGradient(this.g);
            System.arraycopy(this.g, 0, this.oldg, 0, this.g.length);
            System.arraycopy(this.g, 0, this.direction, 0, this.g.length);
            if (MatrixOps.absNormalize(this.direction) == 0.0) {
                logger.info("L-BFGS initial gradient is zero; saying converged");
                this.g = null;
                this.converged = true;
                return true;
            }
            logger.fine("direction.2norm: " + MatrixOps.twoNorm(this.direction));
            MatrixOps.timesEquals(this.direction, 1.0 / MatrixOps.twoNorm(this.direction));
            logger.fine("before initial jump: \ndirection.2norm: " + MatrixOps.twoNorm(this.direction) + " \ngradient.2norm: " + MatrixOps.twoNorm(this.g) + "\nparameters.2norm: " + MatrixOps.twoNorm(this.parameters));
            step = this.lineMaximizer.optimize(this.direction, step);
            if (step == 0.0) {
                this.g = null;
                step = 1.0;
                throw new OptimizationException("Line search could not step in the current direction. (This is not necessarily cause for alarm. Sometimes this happens close to the maximum, where the function may be very flat.)");
            }
            this.optimizable.getParameters(this.parameters);
            this.optimizable.getValueGradient(this.g);
            logger.fine("after initial jump: \ndirection.2norm: " + MatrixOps.twoNorm(this.direction) + " \ngradient.2norm: " + MatrixOps.twoNorm(this.g));
        }
        for (int iterationCount = 0; iterationCount < numIterations; ++iterationCount) {
            int i;
            double value2 = this.optimizable.getValue();
            logger.fine("L-BFGS iteration=" + iterationCount + ", value=" + value2 + " g.twoNorm: " + MatrixOps.twoNorm(this.g) + " oldg.twoNorm: " + MatrixOps.twoNorm(this.oldg));
            double sy = 0.0;
            double yy = 0.0;
            for (int i2 = 0; i2 < this.oldParameters.length; ++i2) {
                this.oldParameters[i2] = Double.isInfinite(this.parameters[i2]) && Double.isInfinite(this.oldParameters[i2]) && this.parameters[i2] * this.oldParameters[i2] > 0.0 ? 0.0 : this.parameters[i2] - this.oldParameters[i2];
                this.oldg[i2] = Double.isInfinite(this.g[i2]) && Double.isInfinite(this.oldg[i2]) && this.g[i2] * this.oldg[i2] > 0.0 ? 0.0 : this.g[i2] - this.oldg[i2];
                sy += this.oldParameters[i2] * this.oldg[i2];
                yy += this.oldg[i2] * this.oldg[i2];
                this.direction[i2] = this.g[i2];
            }
            if (sy > 0.0) {
                throw new InvalidOptimizableException("sy = " + sy + " > 0");
            }
            double gamma = sy / yy;
            if (gamma > 0.0) {
                throw new InvalidOptimizableException("gamma = " + gamma + " > 0");
            }
            this.push(this.rho, 1.0 / sy);
            this.push(this.s, this.oldParameters);
            this.push(this.y, this.oldg);
            assert (this.s.size() == this.y.size()) : "s.size: " + this.s.size() + " y.size: " + this.y.size();
            for (i = this.s.size() - 1; i >= 0; --i) {
                this.alpha[i] = (Double)this.rho.get(i) * MatrixOps.dotProduct((double[])this.s.get(i), this.direction);
                MatrixOps.plusEquals(this.direction, (double[])this.y.get(i), -1.0 * this.alpha[i]);
            }
            MatrixOps.timesEquals(this.direction, gamma);
            for (i = 0; i < this.y.size(); ++i) {
                double beta = (Double)this.rho.get(i) * MatrixOps.dotProduct((double[])this.y.get(i), this.direction);
                MatrixOps.plusEquals(this.direction, (double[])this.s.get(i), this.alpha[i] - beta);
            }
            i = 0;
            while (i < this.oldg.length) {
                this.oldParameters[i] = this.parameters[i];
                this.oldg[i] = this.g[i];
                int n = i++;
                this.direction[n] = this.direction[n] * -1.0;
            }
            logger.fine("before linesearch: direction.gradient.dotprod: " + MatrixOps.dotProduct(this.direction, this.g) + "\ndirection.2norm: " + MatrixOps.twoNorm(this.direction) + "\nparameters.2norm: " + MatrixOps.twoNorm(this.parameters));
            step = this.lineMaximizer.optimize(this.direction, step);
            if (step == 0.0) {
                this.g = null;
                step = 1.0;
                throw new OptimizationException("Line search could not step in the current direction. (This is not necessarily cause for alarm. Sometimes this happens close to the maximum, where the function may be very flat.)");
            }
            this.optimizable.getParameters(this.parameters);
            this.optimizable.getValueGradient(this.g);
            logger.fine("after linesearch: direction.2norm: " + MatrixOps.twoNorm(this.direction));
            double newValue = this.optimizable.getValue();
            if (2.0 * Math.abs(newValue - value2) <= this.tolerance * (Math.abs(newValue) + Math.abs(value2) + 1.0E-5)) {
                logger.info("Exiting L-BFGS on termination #1:\nvalue difference below tolerance (oldValue: " + value2 + " newValue: " + newValue);
                this.converged = true;
                return true;
            }
            double gg = MatrixOps.twoNorm(this.g);
            if (gg < 0.001) {
                logger.fine("Exiting L-BFGS on termination #2: \ngradient=" + gg + " < " + 0.001);
                this.converged = true;
                return true;
            }
            if (gg == 0.0) {
                logger.fine("Exiting L-BFGS on termination #3: \ngradient==0.0");
                this.converged = true;
                return true;
            }
            logger.fine("Gradient = " + gg);
            ++this.iterations;
            if (this.iterations > 1000) {
                System.err.println("Too many iterations in L-BFGS.java. Continuing with current parameters.");
                this.converged = true;
                return true;
            }
            if (this.eval == null || this.eval.evaluate(this.optimizable, iterationCount)) continue;
            logger.fine("Exiting L-BFGS on termination #4: evaluator returned false.");
            this.converged = true;
            return false;
        }
        return false;
    }

    public void reset() {
        this.g = null;
    }

    private void push(LinkedList l, double[] toadd) {
        assert (l.size() <= 4);
        if (l.size() == 4) {
            double[] last2 = (double[])l.get(0);
            System.arraycopy(toadd, 0, last2, 0, toadd.length);
            double[] ptr = last2;
            for (int i = 0; i < l.size() - 1; ++i) {
                l.set(i, (double[])l.get(i + 1));
            }
            l.set(3, ptr);
        } else {
            double[] newArray = new double[toadd.length];
            System.arraycopy(toadd, 0, newArray, 0, toadd.length);
            l.addLast(newArray);
        }
    }

    private void push(LinkedList l, double toadd) {
        assert (l.size() <= 4);
        if (l.size() == 4) {
            l.removeFirst();
            l.addLast(new Double(toadd));
        } else {
            l.addLast(new Double(toadd));
        }
    }
}

