/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.optimize;

import cc.mallet.optimize.InvalidOptimizableException;
import cc.mallet.optimize.LineOptimizer;
import cc.mallet.optimize.Optimizable;
import cc.mallet.types.MatrixOps;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BackTrackLineSearch
implements LineOptimizer.ByGradient {
    private static Logger logger = Logger.getLogger(BackTrackLineSearch.class.getName());
    Optimizable.ByGradientValue function;
    final int maxIterations = 100;
    final double stpmax = 100.0;
    final double EPS = 3.0E-12;
    private double relTolx = 1.0E-7;
    private double absTolx = 1.0E-4;
    final double ALF = 1.0E-4;

    public BackTrackLineSearch(Optimizable.ByGradientValue optimizable) {
        this.function = optimizable;
    }

    public void setRelTolx(double tolx) {
        this.relTolx = tolx;
    }

    public void setAbsTolx(double tolx) {
        this.absTolx = tolx;
    }

    @Override
    public double optimize(double[] line, double initialStep) {
        double slope;
        double fold;
        double[] g = new double[this.function.getNumParameters()];
        double[] x2 = new double[this.function.getNumParameters()];
        double[] oldParameters = new double[this.function.getNumParameters()];
        this.function.getParameters(x2);
        System.arraycopy(x2, 0, oldParameters, 0, x2.length);
        this.function.getValueGradient(g);
        double tmplam = 0.0;
        double alam2 = 0.0;
        double f2 = fold = this.function.getValue();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ENTERING BACKTRACK\n");
            logger.fine("Entering BackTrackLnSrch, value=" + fold + ",\ndirection.oneNorm:" + MatrixOps.oneNorm(line) + "  direction.infNorm:" + MatrixOps.infinityNorm(line));
        }
        assert (!MatrixOps.isNaN(g));
        double sum2 = MatrixOps.twoNorm(line);
        if (sum2 > 100.0) {
            logger.warning("attempted step too big. scaling: sum=" + sum2 + ", stpmax=" + 100.0);
            MatrixOps.timesEquals(line, 100.0 / sum2);
        }
        double newSlope = slope = MatrixOps.dotProduct(g, line);
        logger.fine("slope=" + slope);
        if (slope < 0.0) {
            throw new InvalidOptimizableException("Slope = " + slope + " is negative");
        }
        if (slope == 0.0) {
            throw new InvalidOptimizableException("Slope = " + slope + " is zero");
        }
        double test2 = 0.0;
        for (int i = 0; i < oldParameters.length; ++i) {
            double temp = Math.abs(line[i]) / Math.max(Math.abs(oldParameters[i]), 1.0);
            if (!(temp > test2)) continue;
            test2 = temp;
        }
        double alamin = this.relTolx / test2;
        double alam = 1.0;
        double oldAlam = 0.0;
        int iteration = 0;
        for (iteration = 0; iteration < 100; ++iteration) {
            double f3;
            logger.fine("BackTrack loop iteration " + iteration + ": alam=" + alam + " oldAlam=" + oldAlam);
            logger.fine("before step, x.1norm: " + MatrixOps.oneNorm(x2) + "\nalam: " + alam + "\noldAlam: " + oldAlam);
            assert (alam != oldAlam) : "alam == oldAlam";
            MatrixOps.plusEquals(x2, line, alam - oldAlam);
            logger.fine("after step, x.1norm: " + MatrixOps.oneNorm(x2));
            if (alam < alamin || this.smallAbsDiff(oldParameters, x2)) {
                this.function.setParameters(oldParameters);
                f3 = this.function.getValue();
                logger.warning("EXITING BACKTRACK: Jump too small (alamin=" + alamin + "). Exiting and using xold. Value=" + f3);
                return 0.0;
            }
            this.function.setParameters(x2);
            oldAlam = alam;
            f3 = this.function.getValue();
            logger.fine("value=" + f3);
            if (f3 >= fold + 1.0E-4 * alam * slope) {
                logger.fine("EXITING BACKTRACK: value=" + f3);
                if (f3 < fold) {
                    throw new IllegalStateException("Function did not increase: f=" + f3 + " < " + fold + "=fold");
                }
                return alam;
            }
            if (Double.isInfinite(f3) || Double.isInfinite(f2)) {
                logger.warning("Value is infinite after jump " + oldAlam + ". f=" + f3 + ", f2=" + f2 + ". Scaling back step size...");
                tmplam = 0.2 * alam;
                if (alam < alamin) {
                    this.function.setParameters(oldParameters);
                    f3 = this.function.getValue();
                    logger.warning("EXITING BACKTRACK: Jump too small. Exiting and using xold. Value=" + f3);
                    return 0.0;
                }
            } else if (alam == 1.0) {
                tmplam = -slope / (2.0 * (f3 - fold - slope));
            } else {
                double disc;
                double rhs1 = f3 - fold - alam * slope;
                double rhs2 = f2 - fold - alam2 * slope;
                assert (alam - alam2 != 0.0) : "FAILURE: dividing by alam-alam2. alam=" + alam;
                double a = (rhs1 / (alam * alam) - rhs2 / (alam2 * alam2)) / (alam - alam2);
                double b = (-alam2 * rhs1 / (alam * alam) + alam * rhs2 / (alam2 * alam2)) / (alam - alam2);
                tmplam = a == 0.0 ? -slope / (2.0 * b) : ((disc = b * b - 3.0 * a * slope) < 0.0 ? 0.5 * alam : (b <= 0.0 ? (-b + Math.sqrt(disc)) / (3.0 * a) : -slope / (b + Math.sqrt(disc))));
                if (tmplam > 0.5 * alam) {
                    tmplam = 0.5 * alam;
                }
            }
            alam2 = alam;
            f2 = f3;
            logger.fine("tmplam:" + tmplam);
            alam = Math.max(tmplam, 0.1 * alam);
        }
        if (iteration >= 100) {
            throw new IllegalStateException("Too many iterations.");
        }
        return 0.0;
    }

    private boolean smallAbsDiff(double[] x2, double[] xold) {
        for (int i = 0; i < x2.length; ++i) {
            if (!(Math.abs(x2[i] - xold[i]) > this.absTolx)) continue;
            return false;
        }
        return true;
    }
}

