/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.optimize;

import cc.mallet.optimize.Optimizable;
import cc.mallet.optimize.Optimizer;
import cc.mallet.types.MatrixOps;
import java.util.logging.Logger;

public class AGIS
implements Optimizer {
    private static Logger logger = Logger.getLogger("edu.umass.cs.mallet.base.minimize.AGIS");
    double initialStepSize = 1.0;
    double alpha;
    double eta = 1.0;
    double tolerance = 1.0E-4;
    int maxIterations = 200;
    Optimizable.ByGISUpdate maxable;
    boolean converged = false;
    boolean backTrack;
    final double eps = 1.0E-10;

    public AGIS(Optimizable.ByGISUpdate maxable, double alph) {
        this(maxable, alph, true);
    }

    public AGIS(Optimizable.ByGISUpdate maxable, double alph, boolean backTrack) {
        this.maxable = maxable;
        this.alpha = alph;
        this.backTrack = backTrack;
    }

    @Override
    public Optimizable getOptimizable() {
        return this.maxable;
    }

    @Override
    public boolean isConverged() {
        return this.converged;
    }

    @Override
    public boolean optimize() {
        return this.optimize(this.maxIterations);
    }

    @Override
    public boolean optimize(int numIterations) {
        double[] params = new double[this.maxable.getNumParameters()];
        double[] gis = new double[this.maxable.getNumParameters()];
        double[] old_params = new double[this.maxable.getNumParameters()];
        double[] updates = new double[this.maxable.getNumParameters()];
        this.maxable.getParameters(params);
        this.maxable.getParameters(gis);
        this.maxable.getParameters(old_params);
        for (int iterations = 0; iterations < numIterations; ++iterations) {
            boolean complete = false;
            double old = this.maxable.getValue();
            this.maxable.getGISUpdate(updates);
            MatrixOps.plusEquals(gis, updates);
            MatrixOps.plusEquals(params, updates, this.eta);
            this.maxable.setParameters(params);
            double next2 = this.maxable.getValue();
            if (next2 > old) {
                complete = true;
                if (this.eta * this.alpha < 9.9999999E7) {
                    this.eta *= this.alpha;
                }
            }
            if (this.backTrack && !complete) {
                while (this.eta > 1.0 && !complete) {
                    this.eta /= 2.0;
                    MatrixOps.set(params, old_params);
                    MatrixOps.plusEquals(params, updates, this.eta);
                    this.maxable.setParameters(params);
                    next2 = this.maxable.getValue();
                    if (!(next2 > old)) continue;
                    complete = true;
                }
            } else if (!complete) {
                this.maxable.setParameters(gis);
                this.eta = 1.0;
                next2 = this.maxable.getValue();
            }
            logger.info("eta: " + this.eta);
            if (2.0 * Math.abs(next2 - old) <= this.tolerance * (Math.abs(next2) + Math.abs(old) + 1.0E-10)) {
                this.converged = true;
                return true;
            }
            if (numIterations <= 1) continue;
            this.maxable.getParameters(params);
            this.maxable.getParameters(old_params);
            this.maxable.getParameters(gis);
        }
        this.converged = false;
        return false;
    }
}

