/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.AbstractFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.ConstantFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.util.Maths;
import cc.mallet.util.Randoms;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BetaFactor
extends AbstractFactor {
    private transient Variable var;
    private transient double min;
    private transient double max;
    private transient double alpha;
    private transient double beta;
    private transient double beta12;
    private static final long serialVersionUID = 1L;
    private static final int SERIAL_VERSION = 1;

    public BetaFactor(Variable var, double alpha, double beta) {
        this(var, alpha, beta, 0.0, 1.0);
    }

    public BetaFactor(Variable var, double alpha, double beta, double min2, double max2) {
        super(new HashVarSet(new Variable[]{var}));
        if (!var.isContinuous()) {
            throw new IllegalArgumentException();
        }
        if (min2 >= max2) {
            throw new IllegalArgumentException();
        }
        this.var = var;
        this.min = min2;
        this.max = max2;
        this.alpha = alpha;
        this.beta = beta;
        this.setBeta12();
    }

    private void setBeta12() {
        this.beta12 = 1.0 / Maths.beta(this.alpha, this.beta);
    }

    @Override
    protected Factor extractMaxInternal(VarSet varSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double value(Assignment assn) {
        double pct = this.valueToPct(assn.getDouble(this.var));
        if (0.0 < pct && pct < 1.0) {
            return this.beta12 * Math.pow(pct, this.alpha - 1.0) * Math.pow(1.0 - pct, this.beta - 1.0);
        }
        return 0.0;
    }

    private double valueToPct(double val) {
        return (val - this.min) / (this.max - this.min);
    }

    private double pctToValue(double pct) {
        return pct * (this.max - this.min) + this.min;
    }

    @Override
    protected double lookupValueInternal(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Factor marginalizeInternal(VarSet varsToKeep) {
        if (varsToKeep.contains(this.var)) {
            return this.duplicate();
        }
        return new ConstantFactor(1.0);
    }

    @Override
    public Factor normalize() {
        return this;
    }

    @Override
    public Assignment sample(Randoms r) {
        double pct = r.nextBeta(this.alpha, this.beta);
        double val = this.pctToValue(pct);
        return new Assignment(this.var, val);
    }

    @Override
    public boolean almostEquals(Factor p, double epsilon) {
        return this.equals(p);
    }

    @Override
    public Factor duplicate() {
        return new BetaFactor(this.var, this.alpha, this.beta, this.min, this.max);
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.alpha) || Double.isNaN(this.beta) || Double.isNaN(this.min) || Double.isNaN(this.max) || this.alpha <= 0.0 || this.beta <= 0.0;
    }

    @Override
    public String dumpToString() {
        return this.toString();
    }

    @Override
    public void multiplyBy(Factor f2) {
        double val;
        if (f2 instanceof ConstantFactor && Maths.almostEquals(val = f2.value(new Assignment()), 1.0)) {
            return;
        }
        throw new UnsupportedOperationException("Can't multiply BetaFactor by " + f2);
    }

    @Override
    public void divideBy(Factor f2) {
        double val;
        if (f2 instanceof ConstantFactor && Maths.almostEquals(val = f2.value(new Assignment()), 1.0)) {
            return;
        }
        throw new UnsupportedOperationException("Can't divide BetaFactor by " + f2);
    }

    public String toString() {
        return "[BetaFactor(" + this.alpha + ", " + this.beta + ") " + this.var + " scale=(" + this.min + " ... " + this.max + ") ]";
    }

    @Override
    public Factor slice(Assignment assn) {
        if (assn.containsVar(this.var)) {
            return new ConstantFactor(this.value(assn));
        }
        return this.duplicate();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        in.readInt();
        this.var = (Variable)in.readObject();
        this.alpha = in.readDouble();
        this.beta = in.readDouble();
        this.min = in.readDouble();
        this.max = in.readDouble();
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.defaultWriteObject();
        out.writeInt(1);
        out.writeObject(this.var);
        out.writeDouble(this.alpha);
        out.writeDouble(this.beta);
        out.writeDouble(this.min);
        out.writeDouble(this.max);
        this.setBeta12();
    }
}

