/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.UniNormalFactor;
import cc.mallet.grmm.types.Variable;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.Randoms;
import gnu.trove.TDoubleArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestUniNormalFactor
extends TestCase {
    public TestUniNormalFactor(String name) {
        super(name);
    }

    public void testVarSet() {
        Variable var = new Variable(-1);
        UniNormalFactor f2 = new UniNormalFactor(var, -1.0, 1.5);
        TestUniNormalFactor.assertEquals((int)1, (int)f2.varSet().size());
        TestUniNormalFactor.assertTrue((boolean)f2.varSet().contains(var));
    }

    public void testValue() {
        Variable var = new Variable(-1);
        UniNormalFactor f2 = new UniNormalFactor(var, -1.0, 2.0);
        Assignment assn1 = new Assignment(var, -1.0);
        TestUniNormalFactor.assertEquals((double)0.2821, (double)f2.value(assn1), (double)1.0E-4);
        TestUniNormalFactor.assertEquals((double)Math.log(0.2821), (double)f2.logValue(assn1), (double)1.0E-4);
        Assignment assn2 = new Assignment(var, 1.5);
        TestUniNormalFactor.assertEquals((double)0.05913, (double)f2.value(assn2), (double)1.0E-4);
        TestUniNormalFactor.assertEquals((double)Math.log(0.05913), (double)f2.logValue(assn2), (double)1.0E-4);
    }

    public void testSample() {
        Variable var = new Variable(-1);
        Randoms r = new Randoms(2343);
        UniNormalFactor f2 = new UniNormalFactor(var, -1.0, 2.0);
        TDoubleArrayList lst = new TDoubleArrayList();
        for (int i = 0; i < 10000; ++i) {
            Assignment assn = f2.sample(r);
            lst.add(assn.getDouble(var));
        }
        double[] vals = lst.toNativeArray();
        double mean = MatrixOps.mean(vals);
        double std = MatrixOps.stddev(vals);
        TestUniNormalFactor.assertEquals((double)-1.0, (double)mean, (double)0.025);
        TestUniNormalFactor.assertEquals((double)Math.sqrt(2.0), (double)std, (double)0.01);
    }

    public static TestSuite suite() {
        return new TestSuite(TestUniNormalFactor.class);
    }

    public static void main(String[] args) {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestUniNormalFactor(args[i]));
            }
        } else {
            theSuite = TestUniNormalFactor.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

