/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.inference.RandomGraphs;
import cc.mallet.grmm.inference.TRP;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.UndirectedGrid;
import java.util.Iterator;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestTRP
extends TestCase {
    public TestTRP(String name) {
        super(name);
    }

    public void testEarlyStopping() {
        UndirectedGrid grid = RandomGraphs.randomAttractiveGrid(5, 0.5, new Random(2413421L));
        TRP trp = new TRP(new TRP.IterationTerminator(1));
        trp.setRandomSeed(14312341L);
        trp.computeMarginals(grid);
        boolean oneIsDifferent = false;
        Iterator it = grid.factorsIterator();
        while (it.hasNext()) {
            Factor f2 = (Factor)it.next();
            Factor marg = trp.lookupMarginal(f2.varSet());
            if (marg.almostEquals(f2.duplicate().normalize())) continue;
            oneIsDifferent = true;
        }
        TestTRP.assertTrue((boolean)oneIsDifferent);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTRP.class);
    }

    public static void main(String[] args) {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestTRP(args[i]));
            }
        } else {
            theSuite = TestTRP.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

