/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.inference.RandomGraphs;
import cc.mallet.grmm.types.AbstractTableFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.ConstantFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.LogTableFactor;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.UndirectedGrid;
import cc.mallet.grmm.types.Variable;
import cc.mallet.grmm.util.ModelReader;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.Randoms;
import cc.mallet.util.Timing;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestFactorGraph
extends TestCase {
    private Variable[] vars;
    private TableFactor tbl1;
    private TableFactor tbl2;
    private TableFactor tbl3;
    private LogTableFactor ltbl1;
    private LogTableFactor ltbl2;
    private static String uniformMdlstr = "VAR sigma u1 u2 : continuous\nVAR x1 x2 : 2\nsigma ~ Uniform -0.5 0.5\nu1 ~ Uniform -0.5 0.5\nu2 ~ Uniform -0.5 0.5\nx1 x2 ~ BinaryPair sigma\nx1 ~ Unary u1\nx2 ~ Unary u2\n";
    private static String uniformMdlstr2 = "VAR sigma u1 u2 : continuous\nVAR x1 x2 : 2\nsigma ~ Normal 0.0 0.2\nu1 ~ Normal 0.0 0.2\nu2 ~ Normal 0.0 0.2\nx1 x2 ~ BinaryPair sigma\nx1 ~ Unary u1\nx2 ~ Unary u2\n";

    public TestFactorGraph(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.vars = new Variable[]{new Variable(2), new Variable(2), new Variable(2), new Variable(2)};
        this.tbl1 = new TableFactor(new Variable[]{this.vars[0], this.vars[1]}, new double[]{0.8, 0.1, 0.1, 0.8});
        this.tbl2 = new TableFactor(new Variable[]{this.vars[1], this.vars[2]}, new double[]{0.2, 0.7, 0.8, 0.2});
        this.tbl3 = new TableFactor(new Variable[]{this.vars[2], this.vars[3]}, new double[]{0.2, 0.4, 0.6, 0.4});
        this.ltbl1 = LogTableFactor.makeFromValues(new Variable[]{this.vars[0], this.vars[1]}, new double[]{0.8, 0.1, 0.1, 0.8});
        this.ltbl2 = LogTableFactor.makeFromValues(new Variable[]{this.vars[1], this.vars[2]}, new double[]{0.2, 0.7, 0.8, 0.2});
    }

    public void testMultiplyBy() {
        FactorGraph fg = new FactorGraph();
        fg.multiplyBy(this.tbl1);
        fg.multiplyBy(this.tbl2);
        TestFactorGraph.assertEquals((int)2, (int)fg.factors().size());
        TestFactorGraph.assertTrue((boolean)fg.factors().contains(this.tbl1));
        TestFactorGraph.assertTrue((boolean)fg.factors().contains(this.tbl2));
        TestFactorGraph.assertEquals((int)3, (int)fg.numVariables());
        TestFactorGraph.assertTrue((boolean)fg.variablesSet().contains(this.vars[0]));
        TestFactorGraph.assertTrue((boolean)fg.variablesSet().contains(this.vars[1]));
        TestFactorGraph.assertTrue((boolean)fg.variablesSet().contains(this.vars[2]));
    }

    public void testNumVariables() {
        FactorGraph fg = new FactorGraph();
        fg.multiplyBy(this.tbl1);
        fg.multiplyBy(this.tbl2);
        TestFactorGraph.assertEquals((int)3, (int)fg.numVariables());
    }

    public void testMultiply() {
        FactorGraph fg = new FactorGraph();
        fg.multiplyBy(this.tbl1);
        fg.multiplyBy(this.tbl2);
        FactorGraph fg2 = (FactorGraph)fg.multiply(this.tbl3);
        TestFactorGraph.assertEquals((int)2, (int)fg.factors().size());
        TestFactorGraph.assertEquals((int)3, (int)fg2.factors().size());
        TestFactorGraph.assertTrue((!fg.factors().contains(this.tbl3) ? 1 : 0) != 0);
        TestFactorGraph.assertTrue((boolean)fg2.factors().contains(this.tbl3));
    }

    public void testValue() {
        FactorGraph fg = new FactorGraph();
        fg.multiplyBy(this.tbl1);
        fg.multiplyBy(this.tbl2);
        Assignment assn = new Assignment(fg.varSet().toVariableArray(), new int[]{0, 1, 0});
        TestFactorGraph.assertEquals((double)0.08, (double)fg.value(assn), (double)1.0E-5);
    }

    public void testMarginalize() {
        FactorGraph fg = new FactorGraph();
        fg.multiplyBy(this.tbl1);
        fg.multiplyBy(this.tbl2);
        Factor marg = fg.marginalize(this.vars[1]);
        TableFactor expected = new TableFactor(this.vars[1], new double[]{0.81, 0.9});
        TestFactorGraph.assertTrue((boolean)expected.almostEquals(marg));
    }

    public void testSum() {
        FactorGraph fg = new FactorGraph();
        fg.multiplyBy(this.tbl1);
        fg.multiplyBy(this.tbl2);
        TestFactorGraph.assertEquals((double)1.71, (double)fg.sum(), (double)1.0E-5);
    }

    public void testNormalize() {
        FactorGraph fg = new FactorGraph();
        fg.multiplyBy(this.tbl1);
        fg.multiplyBy(this.tbl2);
        fg.normalize();
        TestFactorGraph.assertEquals((double)1.0, (double)fg.sum(), (double)1.0E-5);
    }

    public void testLogNormalize() {
        FactorGraph fg = new FactorGraph();
        fg.multiplyBy(this.ltbl1);
        fg.multiplyBy(this.ltbl2);
        fg.normalize();
        TestFactorGraph.assertEquals((double)1.0, (double)fg.sum(), (double)1.0E-5);
    }

    public void testEmbeddedFactorGraph() {
        FactorGraph embeddedFg = new FactorGraph();
        embeddedFg.multiplyBy(this.tbl1);
        embeddedFg.multiplyBy(this.tbl2);
        FactorGraph fg = new FactorGraph();
        fg.multiplyBy(embeddedFg);
        fg.multiplyBy(this.tbl3);
        TestFactorGraph.assertEquals((int)4, (int)fg.varSet().size());
        TestFactorGraph.assertEquals((int)2, (int)fg.factors().size());
        Assignment assn = new Assignment(fg.varSet().toVariableArray(), new int[4]);
        TestFactorGraph.assertEquals((double)0.032, (double)fg.value(assn), (double)1.0E-5);
        AbstractTableFactor tbl = fg.asTable();
        TestFactorGraph.assertEquals((int)4, (int)tbl.varSet().size());
        TestFactorGraph.assertEquals((double)0.032, (double)tbl.value(assn), (double)1.0E-5);
    }

    public void testAsTable() {
        FactorGraph fg = new FactorGraph();
        fg.multiplyBy(this.tbl1);
        fg.multiplyBy(this.tbl2);
        AbstractTableFactor actual = fg.asTable();
        AbstractTableFactor expected = (AbstractTableFactor)this.tbl1.multiply(this.tbl2);
        TestFactorGraph.assertTrue((boolean)expected.almostEquals(actual));
    }

    public void testTableTimesFg() {
        FactorGraph fg = new FactorGraph();
        fg.multiplyBy(this.tbl1);
        fg.multiplyBy(this.tbl2);
        Factor product2 = this.tbl3.multiply(fg);
        TestFactorGraph.assertTrue((boolean)(product2 instanceof AbstractTableFactor));
        TestFactorGraph.assertEquals((int)4, (int)product2.varSet().size());
        Assignment assn = new Assignment(product2.varSet().toVariableArray(), new int[4]);
        TestFactorGraph.assertEquals((double)0.032, (double)product2.value(assn), (double)1.0E-5);
    }

    public void testLogTableTimesFg() {
        FactorGraph fg = new FactorGraph();
        fg.multiplyBy(this.tbl1);
        fg.multiplyBy(this.tbl2);
        Factor product2 = this.ltbl1.multiply(fg);
        TestFactorGraph.assertTrue((boolean)(product2 instanceof AbstractTableFactor));
        TestFactorGraph.assertEquals((int)3, (int)product2.varSet().size());
        Assignment assn = new Assignment(product2.varSet().toVariableArray(), new int[3]);
        TestFactorGraph.assertEquals((double)0.128, (double)product2.value(assn), (double)1.0E-5);
    }

    public void testRemove() {
        FactorGraph fg = new FactorGraph();
        fg.multiplyBy(this.tbl1);
        fg.multiplyBy(this.tbl2);
        TestFactorGraph.assertEquals((int)2, (int)fg.getDegree(this.vars[1]));
        fg.divideBy(this.tbl1);
        TestFactorGraph.assertEquals((int)2, (int)fg.varSet().size());
        Assignment assn = new Assignment(fg.varSet().toVariableArray(), new int[2]);
        TestFactorGraph.assertEquals((double)0.2, (double)fg.value(assn), (double)1.0E-5);
        int nvs = 0;
        Iterator it = fg.varSetIterator();
        while (it.hasNext()) {
            ++nvs;
            it.next();
        }
        TestFactorGraph.assertEquals((int)1, (int)nvs);
        TestFactorGraph.assertEquals((int)1, (int)fg.getDegree(this.vars[1]));
        TestFactorGraph.assertTrue((fg.get(0) != fg.get(1) ? 1 : 0) != 0);
        TestFactorGraph.assertEquals((Object)this.vars[1], (Object)fg.get(0));
        TestFactorGraph.assertEquals((Object)this.vars[2], (Object)fg.get(1));
    }

    public void testRedundantDomains() {
        FactorGraph fg = new FactorGraph();
        fg.multiplyBy(this.tbl1);
        fg.multiplyBy(this.tbl2);
        fg.multiplyBy(this.ltbl1);
        TestFactorGraph.assertEquals((int)3, (int)fg.varSet().size());
        TestFactorGraph.assertEquals((String)("Wrong factors in FG, was " + fg.dumpToString()), (int)3, (int)fg.factors().size());
        Assignment assn = new Assignment(fg.varSet().toVariableArray(), new int[3]);
        TestFactorGraph.assertEquals((double)0.128, (double)fg.value(assn), (double)1.0E-5);
    }

    public void testContinousSample() throws IOException {
        ModelReader reader = new ModelReader();
        FactorGraph fg = reader.readModel(new BufferedReader(new StringReader(uniformMdlstr)));
        Randoms r = new Randoms(324143);
        Assignment allAssn = new Assignment();
        for (int i = 0; i < 10000; ++i) {
            Assignment row = fg.sample(r);
            allAssn.addRow(row);
        }
        Variable x1 = fg.findVariable("x1");
        Assignment assn1 = (Assignment)allAssn.marginalize(x1);
        int[] col = assn1.getColumnInt(x1);
        double mean = (double)MatrixOps.sum(col) / (double)col.length;
        TestFactorGraph.assertEquals((double)0.5, (double)mean, (double)0.025);
    }

    public void testContinousSample2() throws IOException {
        ModelReader reader = new ModelReader();
        FactorGraph fg = reader.readModel(new BufferedReader(new StringReader(uniformMdlstr2)));
        Randoms r = new Randoms(324143);
        Assignment allAssn = new Assignment();
        for (int i = 0; i < 10000; ++i) {
            Assignment row = fg.sample(r);
            allAssn.addRow(row);
        }
        Variable x1 = fg.findVariable("x2");
        Assignment assn1 = (Assignment)allAssn.marginalize(x1);
        int[] col = assn1.getColumnInt(x1);
        double mean = (double)MatrixOps.sum(col) / (double)col.length;
        TestFactorGraph.assertEquals((double)0.5, (double)mean, (double)0.01);
        Variable x2 = fg.findVariable("x2");
        Assignment assn2 = (Assignment)allAssn.marginalize(x2);
        int[] col2 = assn2.getColumnInt(x2);
        double mean2 = (double)MatrixOps.sum(col2) / (double)col2.length;
        TestFactorGraph.assertEquals((double)0.5, (double)mean2, (double)0.025);
    }

    public void testAllFactorsOf() throws IOException {
        ModelReader reader = new ModelReader();
        FactorGraph fg = reader.readModel(new BufferedReader(new StringReader(uniformMdlstr2)));
        Variable var = new Variable(2);
        var.setLabel("v0");
        List lst = fg.allFactorsOf(var);
        TestFactorGraph.assertEquals((int)0, (int)lst.size());
    }

    public void testAllFactorsOf2() throws IOException {
        Variable x1 = new Variable(2);
        Variable x2 = new Variable(2);
        FactorGraph fg = new FactorGraph();
        fg.addFactor(new TableFactor(x1));
        fg.addFactor(new TableFactor(x2));
        fg.addFactor(new TableFactor(new Variable[]{x1, x2}));
        List lst = fg.allFactorsOf(x1);
        TestFactorGraph.assertEquals((int)1, (int)lst.size());
        for (Factor f2 : lst) {
            TestFactorGraph.assertEquals((int)1, (int)f2.varSet().size());
            TestFactorGraph.assertTrue((boolean)f2.varSet().contains(x1));
        }
        HashVarSet vs = new HashVarSet(new Variable[]{x1, x2});
        List lst2 = fg.allFactorsOf(vs);
        TestFactorGraph.assertEquals((int)1, (int)lst2.size());
        Factor f3 = (Factor)lst2.get(0);
        TestFactorGraph.assertTrue((boolean)f3.varSet().equals(vs));
    }

    public void testAsTable2() {
        TableFactor f1 = new TableFactor(this.vars[0], new double[]{0.6, 0.4});
        ConstantFactor f2 = new ConstantFactor(2.0);
        FactorGraph fg = new FactorGraph(new Factor[]{f1, f2});
        AbstractTableFactor tbl = fg.asTable();
        TestFactorGraph.assertTrue((boolean)Arrays.equals(new double[]{1.2, 0.8}, tbl.toValueArray()));
    }

    public void testClear() {
        int vi;
        FactorGraph fg = new FactorGraph();
        fg.multiplyBy(this.tbl1);
        fg.multiplyBy(this.tbl2);
        TestFactorGraph.assertEquals((int)3, (int)fg.numVariables());
        TestFactorGraph.assertEquals((int)2, (int)fg.factors().size());
        fg.clear();
        TestFactorGraph.assertEquals((int)0, (int)fg.numVariables());
        TestFactorGraph.assertEquals((int)0, (int)fg.factors().size());
        for (vi = 0; vi < this.tbl1.varSet().size(); ++vi) {
            TestFactorGraph.assertTrue((!fg.containsVar(this.tbl1.getVariable(vi)) ? 1 : 0) != 0);
        }
        for (vi = 0; vi < this.tbl2.varSet().size(); ++vi) {
            TestFactorGraph.assertTrue((!fg.containsVar(this.tbl2.getVariable(vi)) ? 1 : 0) != 0);
        }
    }

    public void testCacheExpanding() {
        UndirectedGrid baseFg = RandomGraphs.randomFrustratedGrid(25, 1.0, new Random(3324879L));
        Assignment assn = new Assignment(baseFg, new int[baseFg.numVariables()]);
        double val = baseFg.logValue(assn);
        Timing timing = new Timing();
        int numReps = 100;
        for (int rep2 = 0; rep2 < numReps; ++rep2) {
            FactorGraph fg = new FactorGraph(baseFg.numVariables());
            for (int fi = 0; fi < baseFg.factors().size(); ++fi) {
                fg.multiplyBy(baseFg.getFactor(fi));
            }
            TestFactorGraph.assertEquals((double)val, (double)fg.logValue(assn), (double)1.0E-5);
        }
        long time1 = timing.elapsedTime();
        timing.tick("No-expansion time");
        for (int rep3 = 0; rep3 < numReps; ++rep3) {
            FactorGraph fg = new FactorGraph();
            for (int fi = 0; fi < baseFg.factors().size(); ++fi) {
                fg.multiplyBy(baseFg.getFactor(fi));
            }
            TestFactorGraph.assertEquals((double)val, (double)fg.logValue(assn), (double)1.0E-5);
        }
        long time2 = timing.elapsedTime();
        timing.tick("With-expansion time");
        TestFactorGraph.assertTrue((time1 < time2 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(TestFactorGraph.class);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestFactorGraph(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestFactorGraph.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

