/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised.pr;

import cc.mallet.fst.CRF;
import cc.mallet.fst.Transducer;
import cc.mallet.types.Sequence;

public class CachedDotTransitionIterator
extends Transducer.TransitionIterator {
    CRF.State source;
    int index;
    int nextIndex;
    protected double[] weights;
    Object input;
    private static final long serialVersionUID = 1L;

    public CachedDotTransitionIterator(CRF.State source, Sequence inputSeq, int inputPosition, String output2, double[] dots) {
        this(source, inputSeq.get(inputPosition), output2, dots);
    }

    protected CachedDotTransitionIterator(CRF.State source, Object fv, String output2, double[] dots) {
        this.source = source;
        this.input = fv;
        this.weights = new double[source.numDestinations()];
        for (int i = 0; i < source.numDestinations(); ++i) {
            this.weights[i] = dots[source.getDestinationState(i).getIndex()];
        }
        this.nextIndex = 0;
        while (this.nextIndex < source.numDestinations() && this.weights[this.nextIndex] == Double.NEGATIVE_INFINITY) {
            ++this.nextIndex;
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.source.numDestinations();
    }

    @Override
    public Transducer.State nextState() {
        assert (this.nextIndex < this.source.numDestinations());
        this.index = this.nextIndex++;
        while (this.nextIndex < this.source.numDestinations() && this.weights[this.nextIndex] == Double.NEGATIVE_INFINITY) {
            ++this.nextIndex;
        }
        return this.source.getDestinationState(this.index);
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final Object getInput() {
        return this.input;
    }

    @Override
    public final Object getOutput() {
        return this.source.getLabelName(this.index);
    }

    @Override
    public final double getWeight() {
        return this.weights[this.index];
    }

    @Override
    public final Transducer.State getSourceState() {
        return this.source;
    }

    @Override
    public final Transducer.State getDestinationState() {
        return this.source.getDestinationState(this.index);
    }
}

