/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised;

import cc.mallet.fst.CRF;
import cc.mallet.fst.SumLattice;
import cc.mallet.fst.semi_supervised.GELattice;
import cc.mallet.fst.semi_supervised.constraints.GEConstraint;
import cc.mallet.types.FeatureVectorSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.concurrent.Callable;

class GELatticeTask
implements Callable<Void> {
    private int start;
    private int end;
    private ArrayList<GEConstraint> constraints;
    private ArrayList<SumLattice> lattices;
    private InstanceList data;
    private CRF crf;
    private CRF.Factors gradient;
    private BitSet instancesWithConstraints;
    private int[][] reverseTrans;
    private int[][] reverseTransIndices;

    public GELatticeTask(CRF crf, InstanceList data2, ArrayList<SumLattice> lattices, ArrayList<GEConstraint> constraints, BitSet instancesWithConstraints, int[][] reverseTrans, int[][] reverseTransIndices, int start, int end) {
        this.crf = crf;
        this.data = data2;
        this.lattices = lattices;
        this.constraints = constraints;
        this.start = start;
        this.end = end;
        this.gradient = new CRF.Factors(crf);
        this.instancesWithConstraints = instancesWithConstraints;
        this.reverseTrans = reverseTrans;
        this.reverseTransIndices = reverseTransIndices;
    }

    public CRF.Factors getGradient() {
        return this.gradient;
    }

    @Override
    public Void call() throws Exception {
        for (int ii = this.start; ii < this.end; ++ii) {
            if (!this.instancesWithConstraints.get(ii)) continue;
            SumLattice lattice = this.lattices.get(ii);
            FeatureVectorSequence fvs = (FeatureVectorSequence)((Instance)this.data.get(ii)).getData();
            new GELattice(fvs, lattice.getGammas(), lattice.getXis(), this.crf, this.reverseTrans, this.reverseTransIndices, this.gradient, this.constraints, false);
        }
        return null;
    }
}

