/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised;

import cc.mallet.types.InstanceList;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;

public class FSTConstraintUtil {
    public static HashMap<Integer, double[][]> loadGEConstraints(Reader fileReader, InstanceList data2) {
        HashMap<Integer, double[][]> constraints = new HashMap<Integer, double[][]>();
        for (int li = 0; li < data2.getTargetAlphabet().size(); ++li) {
            System.err.println(data2.getTargetAlphabet().lookupObject(li));
        }
        try {
            BufferedReader reader = new BufferedReader(fileReader);
            String line = reader.readLine();
            while (line != null) {
                String[] split2 = line.split("\\s+");
                String featureName = split2[0];
                int featureIndex = data2.getDataAlphabet().lookupIndex(featureName, false);
                if (featureIndex == -1) {
                    throw new RuntimeException("Feature " + featureName + " not found in the alphabet!");
                }
                double[][] probs = new double[data2.getTargetAlphabet().size()][2];
                for (int i = 0; i < probs.length; ++i) {
                    Arrays.fill(probs[i], Double.NEGATIVE_INFINITY);
                }
                for (int index = 1; index < split2.length; ++index) {
                    double prob;
                    String[] labelSplit = split2[index].split(":");
                    int li = data2.getTargetAlphabet().lookupIndex(labelSplit[0], false);
                    assert (li != -1) : labelSplit[0];
                    if (labelSplit[1].contains(",")) {
                        String[] rangeSplit = labelSplit[1].split(",");
                        double lower = Double.parseDouble(rangeSplit[0]);
                        double upper = Double.parseDouble(rangeSplit[1]);
                        probs[li][0] = lower;
                        probs[li][1] = upper;
                        continue;
                    }
                    probs[li][0] = prob = Double.parseDouble(labelSplit[1]);
                    probs[li][1] = prob;
                }
                constraints.put(featureIndex, probs);
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return constraints;
    }
}

