/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.confidence;

import cc.mallet.fst.MaxLatticeDefault;
import cc.mallet.fst.Segment;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.confidence.ConstrainedForwardBackwardConfidenceEstimator;
import cc.mallet.fst.confidence.TransducerConfidenceEstimator;
import cc.mallet.fst.confidence.TransducerCorrector;
import cc.mallet.types.ArraySequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;

public class ConstrainedViterbiTransducerCorrector
implements TransducerCorrector {
    private static Logger logger = MalletLogger.getLogger(ConstrainedViterbiTransducerCorrector.class.getName());
    TransducerConfidenceEstimator confidenceEstimator;
    Transducer model;
    ArrayList leastConfidentSegments;

    public ConstrainedViterbiTransducerCorrector(TransducerConfidenceEstimator confidenceEstimator, Transducer model) {
        this.confidenceEstimator = confidenceEstimator;
        this.model = model;
    }

    public ConstrainedViterbiTransducerCorrector(Transducer model) {
        this(new ConstrainedForwardBackwardConfidenceEstimator(model), model);
    }

    public Vector getSegmentConfidences() {
        return this.confidenceEstimator.getSegmentConfidences();
    }

    public ArrayList getLeastConfidentSegments() {
        return this.leastConfidentSegments;
    }

    public ArrayList getLeastConfidentSegments(InstanceList ilist, Object[] startTags, Object[] continueTags) {
        ArrayList<Segment> ret = new ArrayList<Segment>();
        for (int i = 0; i < ilist.size(); ++i) {
            Segment[] orderedSegments = this.confidenceEstimator.rankSegmentsByConfidence((Instance)ilist.get(i), startTags, continueTags);
            ret.add(orderedSegments[0]);
        }
        return ret;
    }

    @Override
    public ArrayList correctLeastConfidentSegments(InstanceList ilist, Object[] startTags, Object[] continueTags) {
        return this.correctLeastConfidentSegments(ilist, startTags, continueTags, false);
    }

    public ArrayList correctLeastConfidentSegments(InstanceList ilist, Object[] startTags, Object[] continueTags, boolean findIncorrect) {
        ArrayList<Sequence<Object>> correctedPredictionList = new ArrayList<Sequence<Object>>();
        this.leastConfidentSegments = new ArrayList();
        logger.info(this.getClass().getName() + " ranking confidence using " + this.confidenceEstimator.getClass().getName());
        for (int i = 0; i < ilist.size(); ++i) {
            int j;
            int j2;
            int j3;
            logger.fine("correcting instance# " + i + " / " + ilist.size());
            Instance instance = (Instance)ilist.get(i);
            Segment[] orderedSegments = new Segment[1];
            Sequence input2 = (Sequence)instance.getData();
            Sequence truth = (Sequence)instance.getTarget();
            Sequence<Object> predicted = new MaxLatticeDefault(this.model, input2).bestOutputSequence();
            int numIncorrect = 0;
            for (j3 = 0; j3 < predicted.size(); ++j3) {
                numIncorrect += !predicted.get(j3).equals(truth.get(j3)) ? 1 : 0;
            }
            if (numIncorrect == 0) {
                this.leastConfidentSegments.add(null);
                correctedPredictionList.add(predicted);
                continue;
            }
            orderedSegments = this.confidenceEstimator.rankSegmentsByConfidence(instance, startTags, continueTags);
            logger.fine("Ordered Segments:\n");
            for (j3 = 0; j3 < orderedSegments.length; ++j3) {
                logger.fine(orderedSegments[j3].toString());
            }
            logger.fine("Correcting Segment: True Sequence:");
            for (j3 = 0; j3 < truth.size(); ++j3) {
                logger.fine((String)truth.get(j3) + "\t");
            }
            logger.fine("");
            logger.fine("Ordered Segments:\n");
            for (j3 = 0; j3 < orderedSegments.length; ++j3) {
                logger.fine(orderedSegments[j3].toString());
            }
            Segment leastConfidentSegment = orderedSegments[0];
            if (findIncorrect) {
                for (int j4 = 0; j4 < orderedSegments.length; ++j4) {
                    if (orderedSegments[j4].correct()) continue;
                    leastConfidentSegment = orderedSegments[j4];
                    break;
                }
            }
            if (findIncorrect && leastConfidentSegment.correct()) {
                logger.warning("cannot find incorrect segment, probably because error is in background state\n");
                this.leastConfidentSegments.add(null);
                correctedPredictionList.add(predicted);
                continue;
            }
            this.leastConfidentSegments.add(leastConfidentSegment);
            if (leastConfidentSegment == null) {
                correctedPredictionList.add(predicted);
                continue;
            }
            String[] sequence2 = new String[truth.size()];
            int numCorrectedTokens = 0;
            for (j2 = 0; j2 < sequence2.length; ++j2) {
                sequence2[j2] = null;
            }
            for (j2 = 0; j2 < truth.size(); ++j2) {
                if (!leastConfidentSegment.indexInSegment(j2)) continue;
                sequence2[j2] = (String)truth.get(j2);
                ++numCorrectedTokens;
            }
            if (leastConfidentSegment.endsPrematurely()) {
                sequence2[leastConfidentSegment.getEnd() + 1] = (String)truth.get(leastConfidentSegment.getEnd() + 1);
                ++numCorrectedTokens;
            }
            logger.fine("Constrained Segment Sequence\n");
            for (j2 = 0; j2 < sequence2.length; ++j2) {
                logger.fine(sequence2[j2]);
            }
            ArraySequence<String> segmentCorrectedOutput = new ArraySequence<String>(sequence2);
            Sequence<Object> correctedPrediction = new MaxLatticeDefault(this.model, orderedSegments[0].getInput(), segmentCorrectedOutput).bestOutputSequence();
            int numIncorrectAfterCorrection = 0;
            for (j = 0; j < truth.size(); ++j) {
                numIncorrectAfterCorrection += !correctedPrediction.get(j).equals(truth.get(j)) ? 1 : 0;
            }
            logger.fine("Num incorrect tokens in original prediction: " + numIncorrect);
            logger.fine("Num corrected tokens: " + numCorrectedTokens);
            logger.fine("Num incorrect tokens after correction-propagation: " + numIncorrectAfterCorrection);
            logger.fine("Correcting Segment: True Sequence:");
            for (j = 0; j < truth.size(); ++j) {
                logger.fine((String)truth.get(j) + "\t");
            }
            logger.fine("\nOriginal prediction: ");
            for (j = 0; j < predicted.size(); ++j) {
                logger.fine((String)predicted.get(j) + "\t");
            }
            logger.fine("\nCorrected prediction: ");
            for (j = 0; j < correctedPrediction.size(); ++j) {
                logger.fine((String)correctedPrediction.get(j) + "\t");
            }
            logger.fine("");
            correctedPredictionList.add(correctedPrediction);
        }
        return correctedPredictionList;
    }
}

