/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.TransducerTrainer;
import cc.mallet.optimize.Optimizable;
import cc.mallet.types.InstanceList;
import cc.mallet.util.MalletLogger;
import java.util.logging.Logger;

public abstract class TransducerEvaluator {
    private static Logger logger = MalletLogger.getLogger(TransducerEvaluator.class.getName());
    protected InstanceList[] instanceLists;
    protected String[] instanceListDescriptions;

    public TransducerEvaluator() {
        this.instanceLists = new InstanceList[0];
        this.instanceListDescriptions = new String[0];
    }

    public TransducerEvaluator(InstanceList[] instanceLists, String[] instanceListDescriptions) {
        this.instanceLists = instanceLists;
        this.instanceListDescriptions = instanceListDescriptions;
    }

    public void evaluate(TransducerTrainer tt) {
        if (!this.precondition(tt)) {
            return;
        }
        this.preamble(tt);
        for (int k = 0; k < this.instanceLists.length; ++k) {
            if (this.instanceLists[k] == null) continue;
            this.evaluateInstanceList(tt, this.instanceLists[k], this.instanceListDescriptions[k]);
        }
    }

    protected void preamble(TransducerTrainer tt) {
        Optimizable opt2;
        int iteration = tt.getIteration();
        if (tt instanceof TransducerTrainer.ByOptimization && (opt2 = ((TransducerTrainer.ByOptimization)((Object)tt)).getOptimizer().getOptimizable()) instanceof Optimizable.ByValue) {
            logger.info("Evaluator iteration=" + iteration + " cost=" + ((Optimizable.ByValue)opt2).getValue());
        } else {
            logger.info("Evaluator iteration=" + iteration + " cost=NA (not Optimizable.ByValue)");
        }
    }

    public boolean precondition(TransducerTrainer tt) {
        return true;
    }

    public abstract void evaluateInstanceList(TransducerTrainer var1, InstanceList var2, String var3);
}

