/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.MaxLatticeDefault;
import cc.mallet.fst.MaxLatticeFactory;
import cc.mallet.fst.SumLatticeDefault;
import cc.mallet.fst.SumLatticeFactory;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Sequence;
import cc.mallet.types.SequencePairAlignment;
import cc.mallet.util.MalletLogger;
import cc.mallet.util.Sequences;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public abstract class Transducer
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(Transducer.class.getName());
    public static final double CERTAIN_WEIGHT = Double.POSITIVE_INFINITY;
    public static final double IMPOSSIBLE_WEIGHT = Double.NEGATIVE_INFINITY;
    SumLatticeFactory sumLatticeFactory = new SumLatticeDefault.Factory();
    MaxLatticeFactory maxLatticeFactory = new MaxLatticeDefault.Factory();
    protected Pipe inputPipe;
    protected Pipe outputPipe;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public Transducer() {
    }

    public Transducer(Pipe inputPipe, Pipe outputPipe) {
        this();
        this.inputPipe = inputPipe;
        this.outputPipe = outputPipe;
    }

    public Pipe getInputPipe() {
        return this.inputPipe;
    }

    public Pipe getOutputPipe() {
        return this.outputPipe;
    }

    public void setSumLatticeFactory(SumLatticeFactory fbf) {
        this.sumLatticeFactory = fbf;
    }

    public void setMaxLatticeFactory(MaxLatticeFactory vf) {
        this.maxLatticeFactory = vf;
    }

    public SumLatticeFactory getSumLatticeFactory() {
        return this.sumLatticeFactory;
    }

    public MaxLatticeFactory getMaxLatticeFactory() {
        return this.maxLatticeFactory;
    }

    public Instance label(Instance instance) {
        if (this.inputPipe != null) {
            instance = this.inputPipe.instanceFrom(instance);
        }
        instance.setTarget(new MaxLatticeDefault(this, (Sequence)instance.getData()).bestOutputSequence());
        if (this.outputPipe != null) {
            instance = this.outputPipe.instanceFrom(instance);
        }
        return instance;
    }

    public Instance transduce(Instance instance) {
        if (this.inputPipe != null) {
            instance = this.inputPipe.instanceFrom(instance);
        }
        instance.setData(new MaxLatticeDefault(this, (Sequence)instance.getData()).bestOutputSequence());
        if (this.outputPipe != null) {
            instance = this.outputPipe.instanceFrom(instance);
        }
        return instance;
    }

    public Sequence transduce(Sequence input2) {
        return this.maxLatticeFactory.newMaxLattice(this, input2).bestOutputSequence();
    }

    public abstract int numStates();

    public abstract State getState(int var1);

    public abstract Iterator initialStateIterator();

    public boolean canIterateAllTransitions() {
        return false;
    }

    public boolean isGenerative() {
        return false;
    }

    public double averageTokenAccuracy(InstanceList ilist) {
        double accuracy = 0.0;
        for (int i = 0; i < ilist.size(); ++i) {
            Instance instance = (Instance)ilist.get(i);
            Sequence input2 = (Sequence)instance.getData();
            Sequence output2 = (Sequence)instance.getTarget();
            assert (input2.size() == output2.size());
            Sequence<Object> predicted = this.maxLatticeFactory.newMaxLattice(this, input2).bestOutputSequence();
            double pathAccuracy = Sequences.elementwiseAccuracy(output2, predicted);
            accuracy += pathAccuracy;
            logger.fine("Transducer path accuracy = " + pathAccuracy);
        }
        return accuracy / (double)ilist.size();
    }

    public SequencePairAlignment generatePath() {
        if (!this.isGenerative()) {
            throw new IllegalStateException("Transducer is not generative.");
        }
        ArrayList initialStates = new ArrayList();
        Iterator iter2 = this.initialStateIterator();
        while (iter2.hasNext()) {
            initialStates.add(iter2.next());
        }
        throw new UnsupportedOperationException();
    }

    public int stateIndexOfString(String s) {
        for (int i = 0; i < this.numStates(); ++i) {
            String state = this.getState(i).getName();
            if (!state.equals(s)) continue;
            return i;
        }
        return -1;
    }

    private void printStates() {
        for (int i = 0; i < this.numStates(); ++i) {
            logger.fine(i + ":" + this.getState(i).getName());
        }
    }

    public void print() {
        logger.fine("Transducer " + this);
        this.printStates();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.inputPipe);
        out.writeObject(this.outputPipe);
        out.writeObject(this.sumLatticeFactory);
        out.writeObject(this.maxLatticeFactory);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.inputPipe = (Pipe)in.readObject();
        this.outputPipe = (Pipe)in.readObject();
        this.sumLatticeFactory = (SumLatticeFactory)in.readObject();
        this.maxLatticeFactory = (MaxLatticeFactory)in.readObject();
    }

    public static double no_longer_needed_sumNegLogProb(double a, double b) {
        if (a == Double.POSITIVE_INFINITY && b == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (a > b) {
            return b - Math.log(1.0 + Math.exp(b - a));
        }
        return a - Math.log(1.0 + Math.exp(a - b));
    }

    public static double sumLogProb(double a, double b) {
        if (a == Double.NEGATIVE_INFINITY) {
            if (b == Double.NEGATIVE_INFINITY) {
                return Double.NEGATIVE_INFINITY;
            }
            return b;
        }
        if (b == Double.NEGATIVE_INFINITY) {
            return a;
        }
        if (a > b) {
            return a + Math.log(1.0 + Math.exp(b - a));
        }
        return b + Math.log(1.0 + Math.exp(a - b));
    }

    public static double less_efficient_sumLogProb(double a, double b) {
        if (a == Double.NEGATIVE_INFINITY && b == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (a > b) {
            return a + Math.log(1.0 + Math.exp(b - a));
        }
        return b + Math.log(1.0 + Math.exp(a - b));
    }

    public static abstract class TransitionIterator
    implements Iterator<State>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;

        @Override
        public abstract boolean hasNext();

        @Deprecated
        public int numberNext() {
            return -1;
        }

        @Deprecated
        public abstract State nextState();

        @Override
        public State next() {
            return this.nextState();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public abstract int getIndex();

        public abstract Object getInput();

        public abstract Object getOutput();

        public abstract double getWeight();

        public abstract State getSourceState();

        public abstract State getDestinationState();

        public int getInputPositionIncrement() {
            return 1;
        }

        public int getOutputPositionIncrement() {
            return 1;
        }

        public Transducer getTransducer() {
            return this.getSourceState().getTransducer();
        }

        public String describeTransition(double cutoff) {
            return "";
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(0);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
        }
    }

    public static interface Incrementor {
        public void incrementTransition(TransitionIterator var1, double var2);

        public void incrementInitialState(State var1, double var2);

        public void incrementFinalState(State var1, double var2);
    }

    public static abstract class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;

        public abstract String getName();

        public abstract int getIndex();

        public abstract double getInitialWeight();

        public abstract void setInitialWeight(double var1);

        public abstract double getFinalWeight();

        public abstract void setFinalWeight(double var1);

        public abstract Transducer getTransducer();

        public abstract TransitionIterator transitionIterator(Sequence var1, int var2, Sequence var3, int var4);

        public TransitionIterator transitionIterator(Sequence input2, int inputPosition) {
            return this.transitionIterator(input2, inputPosition, null, 0);
        }

        public TransitionIterator transitionIterator() {
            return this.transitionIterator(null, 0, null, 0);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(0);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
        }
    }
}

