/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.SumLattice;
import cc.mallet.fst.SumLatticeFactory;
import cc.mallet.fst.Transducer;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelVector;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Logger;

public class SumLatticeScaling
implements SumLattice {
    private static Logger logger = MalletLogger.getLogger(SumLatticeScaling.class.getName());
    protected static boolean saveXis = false;
    Sequence input;
    Sequence output;
    Transducer t;
    double totalWeight;
    LatticeNode[][] nodes;
    double[] alphaLogScaling;
    double[] betaLogScaling;
    double zLogScaling;
    int latticeLength;
    double[][] gammas;
    double[][][] xis;

    protected SumLatticeScaling() {
    }

    protected LatticeNode getLatticeNode(int ip, int stateIndex) {
        if (this.nodes[ip][stateIndex] == null) {
            this.nodes[ip][stateIndex] = new LatticeNode(ip, this.t.getState(stateIndex));
        }
        return this.nodes[ip][stateIndex];
    }

    public SumLatticeScaling(Transducer trans, Sequence input2) {
        this(trans, input2, null, null, saveXis, null);
    }

    public SumLatticeScaling(Transducer trans, Sequence input2, boolean saveXis) {
        this(trans, input2, null, null, saveXis, null);
    }

    public SumLatticeScaling(Transducer trans, Sequence input2, Transducer.Incrementor incrementor) {
        this(trans, input2, null, incrementor, saveXis, null);
    }

    public SumLatticeScaling(Transducer trans, Sequence input2, Sequence output2) {
        this(trans, input2, output2, null, saveXis, null);
    }

    public SumLatticeScaling(Transducer trans, Sequence input2, Sequence output2, Transducer.Incrementor incrementor) {
        this(trans, input2, output2, incrementor, saveXis, null);
    }

    public SumLatticeScaling(Transducer trans, Sequence input2, Sequence output2, Transducer.Incrementor incrementor, LabelAlphabet outputAlphabet) {
        this(trans, input2, output2, incrementor, saveXis, outputAlphabet);
    }

    public SumLatticeScaling(Transducer trans, Sequence input2, Sequence output2, Transducer.Incrementor incrementor, boolean saveXis) {
        this(trans, input2, output2, incrementor, saveXis, null);
    }

    public SumLatticeScaling(Transducer trans, Sequence input2, Sequence output2, Transducer.Incrementor incrementor, boolean saveXis, LabelAlphabet outputAlphabet) {
        int i;
        int i2;
        assert (output2 == null || input2.size() == output2.size());
        this.t = trans;
        this.input = input2;
        this.output = output2;
        this.latticeLength = input2.size() + 1;
        int numStates = this.t.numStates();
        this.nodes = new LatticeNode[this.latticeLength][numStates];
        this.alphaLogScaling = new double[this.latticeLength];
        this.betaLogScaling = new double[this.latticeLength];
        this.gammas = new double[this.latticeLength][numStates];
        if (saveXis) {
            this.xis = new double[this.latticeLength][numStates][numStates];
        }
        double[][] outputCounts = null;
        if (outputAlphabet != null) {
            outputCounts = new double[this.latticeLength][outputAlphabet.size()];
        }
        for (int ip = 0; ip < this.latticeLength; ++ip) {
            this.alphaLogScaling[ip] = 0.0;
            this.betaLogScaling[ip] = 0.0;
            for (i2 = 0; i2 < numStates; ++i2) {
                this.gammas[ip][i2] = Double.NEGATIVE_INFINITY;
                if (!saveXis) continue;
                for (int j = 0; j < numStates; ++j) {
                    this.xis[ip][i2][j] = Double.NEGATIVE_INFINITY;
                }
            }
        }
        logger.fine("Starting Foward pass");
        boolean atLeastOneInitialState = false;
        for (i2 = 0; i2 < numStates; ++i2) {
            double initialWeight = this.t.getState(i2).getInitialWeight();
            if (!(initialWeight > Double.NEGATIVE_INFINITY)) continue;
            this.getLatticeNode((int)0, (int)i2).alpha = Math.exp(initialWeight);
            atLeastOneInitialState = true;
        }
        this.rescaleAlphas(0);
        if (!atLeastOneInitialState) {
            logger.warning("There are no starting states!");
        }
        for (int ip = 0; ip < this.latticeLength - 1; ++ip) {
            for (int i3 = 0; i3 < numStates; ++i3) {
                if (this.isInvalidNode(ip, i3)) continue;
                Transducer.State s = this.t.getState(i3);
                Transducer.TransitionIterator iter2 = s.transitionIterator(input2, ip, output2, ip);
                while (iter2.hasNext()) {
                    Transducer.State destination = iter2.next();
                    LatticeNode destinationNode = this.getLatticeNode(ip + 1, destination.getIndex());
                    if (Double.isNaN(destinationNode.alpha)) {
                        destinationNode.alpha = 0.0;
                    }
                    destinationNode.output = iter2.getOutput();
                    double transitionWeight = iter2.getWeight();
                    destinationNode.alpha += this.nodes[ip][i3].alpha * Math.exp(transitionWeight);
                }
            }
            this.rescaleAlphas(ip + 1);
        }
        double Z = Double.NaN;
        for (i = 0; i < numStates; ++i) {
            if (this.nodes[this.latticeLength - 1][i] == null) continue;
            if (Double.isNaN(Z)) {
                Z = 0.0;
            }
            Z += this.nodes[this.latticeLength - 1][i].alpha * Math.exp(this.t.getState(i).getFinalWeight());
        }
        this.zLogScaling = this.alphaLogScaling[this.latticeLength - 1];
        if (Double.isNaN(Z)) {
            this.totalWeight = Double.NEGATIVE_INFINITY;
            return;
        }
        this.totalWeight = Math.log(Z) + this.zLogScaling;
        for (i = 0; i < numStates; ++i) {
            if (this.nodes[this.latticeLength - 1][i] == null) continue;
            Transducer.State s = this.t.getState(i);
            this.nodes[this.latticeLength - 1][i].beta = Math.exp(s.getFinalWeight());
            double gamma = this.nodes[this.latticeLength - 1][i].alpha * this.nodes[this.latticeLength - 1][i].beta / Z;
            this.gammas[this.latticeLength - 1][i] = Math.log(gamma);
            if (incrementor == null) continue;
            double p = gamma;
            assert (p >= 0.0 && p <= 1.000001) : "p=" + p + ", gamma=" + this.gammas[this.latticeLength - 1][i];
            incrementor.incrementFinalState(s, p);
        }
        this.rescaleBetas(this.latticeLength - 1);
        for (int ip = this.latticeLength - 2; ip >= 0; --ip) {
            for (int i4 = 0; i4 < numStates; ++i4) {
                if (this.isInvalidNode(ip, i4)) continue;
                Transducer.State s = this.t.getState(i4);
                Transducer.TransitionIterator iter3 = s.transitionIterator(input2, ip, output2, ip);
                double logScaling = this.alphaLogScaling[ip] + this.betaLogScaling[ip + 1] - this.zLogScaling;
                double pscaling = Math.exp(logScaling);
                while (iter3.hasNext()) {
                    Transducer.State destination = iter3.next();
                    int j = destination.getIndex();
                    LatticeNode destinationNode = this.nodes[ip + 1][j];
                    if (destinationNode == null) continue;
                    double transitionWeight = iter3.getWeight();
                    if (Double.isNaN(this.nodes[ip][i4].beta)) {
                        this.nodes[ip][i4].beta = 0.0;
                    }
                    double transitionProb = Math.exp(transitionWeight);
                    this.nodes[ip][i4].beta += destinationNode.beta * transitionProb;
                    double xi = this.nodes[ip][i4].alpha * transitionProb * this.nodes[ip + 1][j].beta / Z;
                    if (saveXis) {
                        this.xis[ip][i4][j] = Math.log(xi) + logScaling;
                    }
                    if (incrementor == null && outputAlphabet == null) continue;
                    double p = xi * pscaling;
                    assert (p >= 0.0 && p <= 1.000001) : "p=" + p + ", xis[" + ip + "][" + i4 + "][" + j + "]=" + xi;
                    if (incrementor != null) {
                        incrementor.incrementTransition(iter3, p);
                    }
                    if (outputAlphabet == null) continue;
                    int outputIndex = outputAlphabet.lookupIndex(iter3.getOutput(), false);
                    assert (outputIndex >= 0);
                    double[] dArray = outputCounts[ip];
                    int n = outputIndex;
                    dArray[n] = dArray[n] + p;
                }
                this.gammas[ip][i4] = Math.log(this.nodes[ip][i4].alpha * this.nodes[ip][i4].beta / Z) + logScaling;
            }
            this.rescaleBetas(ip);
        }
        if (incrementor != null) {
            for (i = 0; i < numStates; ++i) {
                double p = Math.exp(this.gammas[0][i]);
                assert (p >= 0.0 && p <= 1.000001) : "p=" + p;
                incrementor.incrementInitialState(this.t.getState(i), p);
            }
        }
    }

    private boolean isInvalidNode(int ip, int i) {
        return this.nodes[ip][i] == null || Double.isNaN(this.nodes[ip][i].alpha);
    }

    private void rescaleAlphas(int ip) {
        int i;
        double sumAlpha = 0.0;
        for (i = 0; i < this.t.numStates(); ++i) {
            if (this.isInvalidNode(ip, i)) continue;
            sumAlpha += this.nodes[ip][i].alpha;
        }
        assert (sumAlpha > 0.0) : "Invalid sum over alphas for ip=" + ip;
        this.alphaLogScaling[ip] = Math.log(sumAlpha) + (ip == 0 ? 0.0 : this.alphaLogScaling[ip - 1]);
        for (i = 0; i < this.t.numStates(); ++i) {
            if (this.isInvalidNode(ip, i)) continue;
            this.nodes[ip][i].alpha /= sumAlpha;
        }
    }

    private void rescaleBetas(int ip) {
        int i;
        double sumBeta = 0.0;
        for (i = 0; i < this.t.numStates(); ++i) {
            if (this.isInvalidNode(ip, i)) continue;
            sumBeta += this.nodes[ip][i].beta;
        }
        assert (sumBeta > 0.0) : "Invalid sum over betas for ip=" + ip;
        this.betaLogScaling[ip] = Math.log(sumBeta) + (ip == this.latticeLength - 1 ? 0.0 : this.betaLogScaling[ip + 1]);
        for (i = 0; i < this.t.numStates(); ++i) {
            if (this.isInvalidNode(ip, i)) continue;
            this.nodes[ip][i].beta /= sumBeta;
        }
    }

    @Override
    public double[][][] getXis() {
        return this.xis;
    }

    @Override
    public double[][] getGammas() {
        return this.gammas;
    }

    @Override
    public double getTotalWeight() {
        return this.totalWeight;
    }

    @Override
    public double getGammaWeight(int inputPosition, Transducer.State s) {
        return this.gammas[inputPosition][s.getIndex()];
    }

    public double getGammaWeight(int inputPosition, int stateIndex) {
        return this.gammas[inputPosition][stateIndex];
    }

    @Override
    public double getGammaProbability(int inputPosition, Transducer.State s) {
        return Math.exp(this.gammas[inputPosition][s.getIndex()]);
    }

    public double getGammaProbability(int inputPosition, int stateIndex) {
        return this.getGammaProbability(inputPosition, this.t.getState(stateIndex));
    }

    @Override
    public double getXiProbability(int ip, Transducer.State s1, Transducer.State s2) {
        return Math.exp(this.getXiWeight(ip, s1, s2));
    }

    @Override
    public double getXiWeight(int ip, Transducer.State s1, Transducer.State s2) {
        if (this.xis == null) {
            throw new IllegalStateException("xis were not saved.");
        }
        int i = s1.getIndex();
        int j = s2.getIndex();
        return this.xis[ip][i][j];
    }

    @Override
    public int length() {
        return this.latticeLength;
    }

    @Override
    public double getAlpha(int ip, Transducer.State s) {
        LatticeNode node = this.getLatticeNode(ip, s.getIndex());
        return node.alpha * Math.exp(this.alphaLogScaling[ip]);
    }

    @Override
    public double getBeta(int ip, Transducer.State s) {
        LatticeNode node = this.getLatticeNode(ip, s.getIndex());
        return node.beta * Math.exp(this.betaLogScaling[ip]);
    }

    @Override
    public LabelVector getLabelingAtPosition(int outputPosition) {
        throw new RuntimeException("Not implemented for SumLatticeScaling!");
    }

    @Override
    public Sequence getInput() {
        return this.input;
    }

    @Override
    public Transducer getTransducer() {
        return this.t;
    }

    public static class Factory
    extends SumLatticeFactory
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 1;

        @Override
        public SumLattice newSumLattice(Transducer trans, Sequence input2, Sequence output2, Transducer.Incrementor incrementor, boolean saveXis, LabelAlphabet outputAlphabet) {
            return new SumLatticeScaling(trans, input2, output2, incrementor, saveXis, outputAlphabet);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(1);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
        }
    }

    protected class LatticeNode {
        int inputPosition;
        Transducer.State state;
        Object output;
        double alpha = Double.NaN;
        double beta = Double.NaN;

        LatticeNode(int inputPosition, Transducer.State state) {
            this.inputPosition = inputPosition;
            this.state = state;
        }
    }
}

