/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract;

import cc.mallet.extract.DocumentExtraction;
import cc.mallet.extract.ExtractionConfidenceEstimator;
import cc.mallet.extract.LabeledSpan;
import cc.mallet.extract.LabeledSpans;
import cc.mallet.extract.Tokenization;
import cc.mallet.fst.Segment;
import cc.mallet.fst.SumLatticeDefault;
import cc.mallet.fst.confidence.TransducerConfidenceEstimator;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Sequence;
import java.io.Serializable;

public class TransducerExtractionConfidenceEstimator
extends ExtractionConfidenceEstimator
implements Serializable {
    TransducerConfidenceEstimator confidenceEstimator;
    Pipe featurePipe;

    public TransducerExtractionConfidenceEstimator(TransducerConfidenceEstimator confidenceEstimator, Object[] startTags, Object[] continueTags, Pipe featurePipe) {
        this.confidenceEstimator = confidenceEstimator;
        this.featurePipe = featurePipe;
    }

    @Override
    public void estimateConfidence(DocumentExtraction documentExtraction) {
        Tokenization input2 = documentExtraction.getInput();
        Instance carrier = this.featurePipe.pipe(new Instance(input2, null, null, null));
        Sequence pipedInput = (Sequence)carrier.getData();
        Sequence prediction = documentExtraction.getPredictedLabels();
        LabeledSpans labeledSpans = documentExtraction.getExtractedSpans();
        SumLatticeDefault lattice = new SumLatticeDefault(this.confidenceEstimator.getTransducer(), pipedInput);
        for (int i = 0; i < labeledSpans.size(); ++i) {
            LabeledSpan span2 = labeledSpans.getLabeledSpan(i);
            if (span2.isBackground()) continue;
            int[] segmentBoundaries = this.getSegmentBoundaries(input2, span2);
            Segment segment = new Segment(pipedInput, prediction, prediction, segmentBoundaries[0], segmentBoundaries[1], null, null);
            span2.setConfidence(this.confidenceEstimator.estimateConfidenceFor(segment, lattice));
        }
    }

    private int[] getSegmentBoundaries(Tokenization tokens, LabeledSpan labeledSpan) {
        int startCharIndex = labeledSpan.getStartIdx();
        int endCharIndex = labeledSpan.getEndIdx() - 1;
        int[] ret = new int[]{-1, -1};
        for (int i = 0; i < tokens.size(); ++i) {
            int charIndex = tokens.getSpan(i).getStartIdx();
            if (charIndex > endCharIndex || charIndex < startCharIndex) continue;
            if (ret[0] == -1) {
                ret[0] = i;
                ret[1] = i;
                continue;
            }
            ret[1] = i;
        }
        if (ret[0] == -1 || ret[1] == -1) {
            throw new IllegalArgumentException("Unable to find segment boundaries from span " + labeledSpan);
        }
        return ret;
    }
}

