/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract;

import cc.mallet.extract.Span;
import cc.mallet.extract.StringSpan;
import cc.mallet.extract.Tokenization;
import cc.mallet.types.TokenSequence;
import cc.mallet.util.CharSequenceLexer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class StringTokenization
extends TokenSequence
implements Tokenization {
    private CharSequence document;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public StringTokenization(CharSequence seq2) {
        this.document = seq2;
    }

    public StringTokenization(CharSequence string2, CharSequenceLexer lexer) {
        this.document = string2;
        lexer.setCharSequence(string2);
        while (lexer.hasNext()) {
            lexer.next();
            this.add(new StringSpan(string2, lexer.getStartOffset(), lexer.getEndOffset()));
        }
    }

    @Override
    public Span subspan(int firstToken, int lastToken) {
        int endIdx;
        StringSpan firstSpan = (StringSpan)this.get(firstToken);
        int startIdx = firstSpan.getStartIdx();
        if (lastToken > this.size()) {
            endIdx = this.document.length();
        } else {
            StringSpan lastSpan = (StringSpan)this.get(lastToken - 1);
            endIdx = lastSpan.getEndIdx();
        }
        return new StringSpan(this.document, startIdx, endIdx);
    }

    @Override
    public Span getSpan(int i) {
        return (Span)this.get(i);
    }

    @Override
    public Object getDocument() {
        return this.document;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
    }
}

