/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract;

import cc.mallet.extract.Span;
import cc.mallet.types.Label;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class LabeledSpan
implements Span,
Serializable {
    private Span span;
    private Label label;
    private boolean isBackground;
    private double confidence;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public LabeledSpan(Span span2, Label label, boolean isBackground) {
        this(span2, label, isBackground, 1.0);
    }

    public LabeledSpan(Span span2, Label label, boolean isBackground, double confidence) {
        this.span = span2;
        this.label = label;
        this.isBackground = isBackground;
        this.confidence = confidence;
    }

    public Span getSpan() {
        return this.span;
    }

    public Label getLabel() {
        return this.label;
    }

    @Override
    public String getText() {
        return this.span.getText();
    }

    @Override
    public Object getDocument() {
        return this.span.getDocument();
    }

    public double getConfidence() {
        return this.confidence;
    }

    void setConfidence(double c) {
        this.confidence = c;
    }

    @Override
    public boolean intersects(Span r) {
        return this.span.intersects(r);
    }

    @Override
    public boolean isSubspan(Span r) {
        return this.span.isSubspan(r);
    }

    @Override
    public Span intersection(Span r) {
        LabeledSpan other = (LabeledSpan)r;
        Span newSpan = this.getSpan().intersection(other.getSpan());
        return new LabeledSpan(newSpan, this.label, this.isBackground, this.confidence);
    }

    @Override
    public int getEndIdx() {
        return this.span.getEndIdx();
    }

    @Override
    public int getStartIdx() {
        return this.span.getStartIdx();
    }

    public boolean isBackground() {
        return this.isBackground;
    }

    public String toString() {
        return this.label.toString() + " [span " + this.getStartIdx() + ".." + this.getEndIdx() + " confidence=" + this.confidence + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        in.readInt();
    }
}

