/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract;

import cc.mallet.extract.DocumentExtraction;
import cc.mallet.extract.Extraction;
import cc.mallet.extract.LabeledSpan;
import cc.mallet.extract.LabeledSpans;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.util.ColorUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class DocumentViewer {
    private static final String DOC_ERRS_CSS_FNAME = "docerrs.css";
    private static final String DOC_ERRS_PRED_CSS_FNAME = "docerrs-by-pred.css";
    private static final String DOC_ERRS_TRUE_CSS_FNAME = "docerrs-by-true.css";
    private static final double SATURATION = 0.4;

    public static void writeExtraction(File directory, Extraction extraction) throws IOException {
        DocumentViewer.outputIndex(directory, extraction);
        DocumentViewer.outputStylesheets(directory, extraction);
        DocumentViewer.outputDocuments(directory, extraction);
    }

    private static void outputStylesheets(File directory, Extraction extraction) throws IOException {
        int i;
        PrintWriter out = new PrintWriter(new FileWriter(new File(directory, DOC_ERRS_CSS_FNAME)));
        out.println(".tf_legend { border-style: dashed; border-width: 2px; padding: 10px; padding-top: 0ex; float: right; margin:2em; }");
        out.println(".class_legend { visibility: hidden; }");
        out.println(".correct { background-color:#33FF33; }");
        out.println(".wrong { background-color:pink }");
        out.println(".true { background-color:#99CCFF; }");
        out.println(".pred { background-color:#FFFF66 }");
        out.close();
        LabelAlphabet dict = extraction.getLabelAlphabet();
        String[] fields = DocumentViewer.determineFieldNames(dict);
        String[] colors = ColorUtils.rainbow(fields.length, 0.4f, 1.0f);
        out = new PrintWriter(new FileWriter(new File(directory, DOC_ERRS_PRED_CSS_FNAME)));
        out.println(".class_legend { border-style: dashed; border-width: 2px; padding: 10px; padding-top: 0ex; float: right; margin:2em; }");
        out.println(".tf_legend { visibility: hidden; }");
        for (i = 0; i < fields.length; ++i) {
            out.println(".pred_" + fields[i] + " { background-color:" + colors[i] + "; }");
        }
        out.close();
        out = new PrintWriter(new FileWriter(new File(directory, DOC_ERRS_TRUE_CSS_FNAME)));
        out.println(".class_legend { border-style: dashed; border-width: 2px; padding: 10px; padding-top: 0ex; float: right; margin:2em; }");
        out.println(".tf_legend { visibility: hidden; }");
        for (i = 0; i < fields.length; ++i) {
            out.println(".true_" + fields[i] + " { background-color:" + colors[i] + "; }");
        }
        out.close();
    }

    private static void outputDocuments(File directory, Extraction extraction) throws IOException {
        for (int i = 0; i < extraction.getNumDocuments(); ++i) {
            PrintWriter out = new PrintWriter(new FileWriter(new File(directory, "extraction" + i + ".html")));
            DocumentViewer.outputOneDocument(out, extraction.getDocumentExtraction(i));
            out.close();
        }
    }

    private static void outputOneDocument(PrintWriter out, DocumentExtraction docExtr) {
        String name = docExtr.getName();
        out.println("<HTML><HEAD><TITLE>" + name + ": Extraction from Document</TITLE>");
        out.println("<LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"docerrs.css\" title=\"Agreement\" />");
        out.println("<LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"docerrs-by-pred.css\" title=\"Pred\" />");
        out.println("<LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"docerrs-by-true.css\" title=\"True\" />");
        out.println("</HEAD><BODY>");
        DocumentViewer.outputClassLegend(out, docExtr.getExtractedSpans().getLabeledSpan(0).getLabel().getLabelAlphabet());
        DocumentViewer.outputRightWrongLegend(out);
        DualLabeledSpans spans = DocumentViewer.intersectSpans(docExtr);
        for (int i = 0; i < spans.size(); ++i) {
            LabeledSpan predSpan = spans.get(i, 0);
            LabeledSpan trueSpan = spans.get(i, 1);
            Label predLabel = predSpan.getLabel();
            Label trueLabel = trueSpan.getLabel();
            boolean predNonBgrnd = !predSpan.isBackground();
            boolean trueNonBgrnd = !trueSpan.isBackground();
            boolean isBackground = !predNonBgrnd && !trueNonBgrnd;
            String spanClass = null;
            if (predNonBgrnd && trueNonBgrnd) {
                spanClass = predLabel == trueLabel ? "correct" : "wrong";
            } else if (predNonBgrnd) {
                spanClass = "pred";
            } else if (trueNonBgrnd) {
                spanClass = "true";
            }
            if (!isBackground) {
                out.print("<SPAN CLASS=\"pred_" + predLabel + "\">");
            }
            if (!isBackground) {
                out.print("<SPAN CLASS=\"true_" + trueLabel + "\">");
            }
            if (spanClass != null) {
                out.print("<SPAN CLASS=\"" + spanClass + "\">");
            }
            String text2 = predSpan.getSpan().getText();
            text2 = text2.replaceAll("<", "&lt;");
            text2 = text2.replaceAll("\n", "\n<P>");
            out.print(text2);
            if (spanClass != null) {
                out.print("</SPAN>");
            }
            if (!isBackground) {
                out.print("</SPAN></SPAN>");
            }
            out.println();
        }
        out.println("</BODY></HTML>");
    }

    private static void outputRightWrongLegend(PrintWriter out) {
        out.println("<DIV CLASS=\"tf_legend\"><B>LEGEND</B><BR>");
        out.println("<SPAN CLASS='correct'>Correct</SPAN><BR />");
        out.println("<SPAN CLASS='wrong'>Wrong</SPAN><BR />");
        out.println("<SPAN CLASS='true'>False Negative</SPAN> (True field but predicted background)<BR />");
        out.println("<SPAN CLASS='pred'>False Positive</SPAN> (True background but predicted field)<BR />");
        out.println("</DIV>");
    }

    private static void outputClassLegend(PrintWriter out, LabelAlphabet dict) {
        out.println("<DIV CLASS=\"class_legend\">");
        out.println("<H4>LEGEND</H4>");
        String[] fields = DocumentViewer.determineFieldNames(dict);
        String[] colors = ColorUtils.rainbow(fields.length, 0.4f, 1.0f);
        for (int i = 0; i < fields.length; ++i) {
            out.println("<SPAN STYLE=\"background-color:" + colors[i] + "\">" + fields[i] + "</SPAN><BR />");
        }
        out.println("</DIV>");
    }

    private static String[] determineFieldNames(LabelAlphabet dict) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < dict.size(); ++i) {
            String lname = dict.lookupLabel(i).toString();
            if (lname.startsWith("B-") || lname.startsWith("I-")) continue;
            l.add(lname);
        }
        return l.toArray(new String[l.size()]);
    }

    private static DualLabeledSpans intersectSpans(DocumentExtraction docExtr) {
        int predIdx = 0;
        int trueIdx = 0;
        LabeledSpans trueSpans = docExtr.getTargetSpans();
        LabeledSpans predSpans = docExtr.getExtractedSpans();
        LabeledSpans retPredSpans = new LabeledSpans(predSpans.getDocument());
        LabeledSpans retTrueSpans = new LabeledSpans(predSpans.getDocument());
        while (predIdx < predSpans.size() && trueIdx < trueSpans.size()) {
            LabeledSpan predSpan = predSpans.getLabeledSpan(predIdx);
            LabeledSpan trueSpan = trueSpans.getLabeledSpan(trueIdx);
            LabeledSpan newPredSpan = (LabeledSpan)predSpan.intersection(trueSpan);
            LabeledSpan newTrueSpan = (LabeledSpan)trueSpan.intersection(predSpan);
            retPredSpans.add(newPredSpan);
            retTrueSpans.add(newTrueSpan);
            if (predSpan.getEndIdx() <= trueSpan.getEndIdx()) {
                ++predIdx;
            }
            if (trueSpan.getEndIdx() > predSpan.getEndIdx()) continue;
            ++trueIdx;
        }
        assert (retPredSpans.size() == retTrueSpans.size());
        return new DualLabeledSpans(retPredSpans, retTrueSpans);
    }

    private static void outputIndex(File directory, Extraction extraction) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(new File(directory, "index.html")));
        out.println("<HTML><HEAD><TITLE>Extraction Results</TITLE></HEAD><BODY><OL>");
        for (int i = 0; i < extraction.getNumDocuments(); ++i) {
            String name = extraction.getDocumentExtraction(i).getName();
            out.println("  <LI><A HREF=\"extraction" + i + ".html\">" + name + "</A></LI>");
        }
        out.println("</OL></BODY></HTML>");
        out.close();
    }

    private static class DualLabeledSpans {
        private LabeledSpans[] ls;

        DualLabeledSpans(LabeledSpans ls1, LabeledSpans ls2) {
            this.ls = new LabeledSpans[]{ls1, ls2};
        }

        int size() {
            return this.ls[0].size();
        }

        LabeledSpan get(int t, int i) {
            return this.ls[i].getLabeledSpan(t);
        }
    }
}

