/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.tui;

import cc.mallet.classify.Classifier;
import cc.mallet.pipe.iterator.UnlabeledFileIterator;
import cc.mallet.types.Instance;
import cc.mallet.types.Labeling;
import cc.mallet.util.CommandOption;
import cc.mallet.util.MalletLogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.logging.Logger;

public class Text2Classify {
    private static Logger logger = MalletLogger.getLogger(Text2Classify.class.getName());
    static CommandOption.SpacedStrings classDirs = new CommandOption.SpacedStrings(Text2Classify.class, "input", "DIR...", true, null, "The directories containing text files to be classified, one directory per class", null);
    static CommandOption.File outputFile = new CommandOption.File(Text2Classify.class, "output", "FILE", true, new File("output"), "Write predictions to this file; Using - indicates stdout.", null);
    static CommandOption.File classifierFile = new CommandOption.File(Text2Classify.class, "classifier", "FILE", true, new File("classifier"), "Use the pipe and alphabets from a previously created vectors file.\n   Allows the creation, for example, of a test set of vectors that are\n   compatible with a previously created set of training vectors", null);
    static CommandOption.String encoding = new CommandOption.String(Text2Classify.class, "encoding", "STRING", true, Charset.defaultCharset().displayName(), "Character encoding for input file", null);

    public static void main(String[] args) throws FileNotFoundException, IOException {
        CommandOption.setSummary(Text2Classify.class, "A tool for classifying a stream of unlabeled instances");
        CommandOption.process(Text2Classify.class, args);
        if (args.length == 0) {
            CommandOption.getList(Text2Classify.class).printUsage(false);
            System.exit(-1);
        }
        if (Text2Classify.classDirs.value.length == 0) {
            throw new IllegalArgumentException("You must include --input DIR1 DIR2 ...' in order to specify a list of directories containing the documents.");
        }
        Classifier classifier = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(Text2Classify.classifierFile.value)));
            classifier = (Classifier)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Problem loading classifier from file " + Text2Classify.classifierFile.value + ": " + e.getMessage());
        }
        File[] directories = new File[Text2Classify.classDirs.value.length];
        for (int i = 0; i < Text2Classify.classDirs.value.length; ++i) {
            directories[i] = new File(Text2Classify.classDirs.value[i]);
        }
        UnlabeledFileIterator fileIterator = new UnlabeledFileIterator(directories);
        Iterator<Instance> iterator2 = classifier.getInstancePipe().newIteratorFrom(fileIterator);
        PrintStream out = null;
        out = Text2Classify.outputFile.value.toString().equals("-") ? System.out : new PrintStream(Text2Classify.outputFile.value, Text2Classify.encoding.value);
        classifier.getInstancePipe().getDataAlphabet().stopGrowth();
        classifier.getInstancePipe().getTargetAlphabet().stopGrowth();
        while (iterator2.hasNext()) {
            Instance instance = iterator2.next();
            Labeling labeling = classifier.classify(instance).getLabeling();
            StringBuilder output2 = new StringBuilder();
            output2.append(instance.getName());
            for (int location = 0; location < labeling.numLocations(); ++location) {
                output2.append("\t" + labeling.labelAtLocation(location));
                output2.append("\t" + labeling.valueAtLocation(location));
            }
            out.println(output2);
        }
        if (!Text2Classify.outputFile.value.toString().equals("-")) {
            out.close();
        }
    }
}

