/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.tests;

import cc.mallet.classify.MaxEnt;
import cc.mallet.classify.MaxEntOptimizableByLabelLikelihood;
import cc.mallet.classify.MaxEntTrainer;
import cc.mallet.optimize.tests.TestOptimizable;
import cc.mallet.types.Alphabet;
import cc.mallet.types.InstanceList;
import cc.mallet.util.Randoms;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestMaxEntTrainer
extends TestCase {
    public TestMaxEntTrainer(String name) {
        super(name);
    }

    private static Alphabet dictOfSize(int size2) {
        Alphabet ret = new Alphabet();
        for (int i = 0; i < size2; ++i) {
            ret.lookupIndex("feature" + i);
        }
        return ret;
    }

    public void testSetGetParameters() {
        MaxEntTrainer trainer = new MaxEntTrainer();
        Alphabet fd = TestMaxEntTrainer.dictOfSize(6);
        String[] classNames = new String[]{"class0", "class1", "class2"};
        InstanceList ilist = new InstanceList(new Randoms(1), fd, classNames, 20);
        MaxEntOptimizableByLabelLikelihood maxable = trainer.getOptimizable(ilist);
        TestOptimizable.testGetSetParameters(maxable);
    }

    public void testRandomMaximizable() {
        MaxEntTrainer trainer = new MaxEntTrainer();
        Alphabet fd = TestMaxEntTrainer.dictOfSize(6);
        String[] classNames = new String[]{"class0", "class1"};
        InstanceList ilist = new InstanceList(new Randoms(1), fd, classNames, 20);
        MaxEntOptimizableByLabelLikelihood maxable = trainer.getOptimizable(ilist);
        TestOptimizable.testValueAndGradient(maxable);
    }

    public void testTrainedMaximizable() {
        MaxEntTrainer trainer = new MaxEntTrainer();
        Alphabet fd = TestMaxEntTrainer.dictOfSize(6);
        String[] classNames = new String[]{"class0", "class1"};
        InstanceList ilist = new InstanceList(new Randoms(1), fd, classNames, 20);
        MaxEnt me = trainer.train(ilist);
        MaxEntOptimizableByLabelLikelihood maxable = trainer.getOptimizable(ilist, me);
        TestOptimizable.testValueAndGradientCurrentParameters(maxable);
    }

    public static Test suite() {
        return new TestSuite(TestMaxEntTrainer.class);
    }

    protected void setUp() {
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestMaxEntTrainer.suite());
    }
}

