/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.evaluate;

import cc.mallet.classify.evaluate.GraphItem;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;

public class Graph
extends Canvas {
    int top;
    int bottom;
    int left;
    int right;
    int titleHeight;
    int labelWidth;
    FontMetrics fm;
    int padding = 4;
    String title;
    String xLabel;
    String yLabel;
    int xLabelHeight;
    int yLabelWidth;
    int min;
    int max;
    int xmin;
    int xmax;
    Legend legend;
    Vector items;

    public Graph(String title, int min2, int max2, String xLabel, String yLabel) {
        this.title = title;
        this.min = min2;
        this.max = max2;
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.legend = new Legend();
        this.items = new Vector();
    }

    @Override
    public void setBounds(int x2, int y, int width, int height) {
        super.setBounds(x2, y, width, height);
        this.fm = this.getFontMetrics(this.getFont());
        this.titleHeight = this.fm.getHeight();
        this.yLabelWidth = this.fm.stringWidth(this.yLabel);
        this.xLabelHeight = this.fm.getHeight();
        this.labelWidth = Math.max(this.fm.stringWidth(new Integer(this.min).toString()), this.fm.stringWidth(new Integer(this.max).toString())) + 2;
        this.top = this.padding + this.titleHeight;
        this.bottom = this.getSize().height - this.padding - this.xLabelHeight - this.fm.getHeight();
        this.left = this.padding + this.yLabelWidth;
        this.right = this.getSize().width - this.padding;
    }

    @Override
    public void paint(Graphics g) {
        this.xmin = 0;
        this.xmax = 100;
        this.fm = this.getFontMetrics(this.getFont());
        g.drawString(this.title, (this.getSize().width - this.fm.stringWidth(this.title)) / 2, this.top - this.padding);
        g.drawString(this.yLabel, 0, this.getSize().height / 2);
        g.drawString(this.xLabel, (this.getSize().width - this.fm.stringWidth(this.xLabel)) / 2, this.bottom + this.fm.getHeight());
        g.drawString(new Integer(this.min).toString(), this.left - this.padding - this.fm.stringWidth(new Integer(this.min).toString()), this.bottom);
        g.drawString(new Integer(this.max).toString(), this.left - this.padding - this.fm.stringWidth(new Integer(this.max).toString()), this.top + this.titleHeight);
        g.drawString(new Integer(this.xmin).toString(), this.left, this.bottom + this.fm.getHeight());
        g.drawString(new Integer(this.xmax).toString(), this.right - this.fm.stringWidth(new Integer(this.xmax).toString()), this.bottom + this.fm.getHeight());
        g.drawLine(this.left, this.top, this.left, this.bottom);
        g.drawLine(this.left, this.bottom, this.right, this.bottom);
        int legendHeight = this.fm.getHeight() * this.legend.size();
        int legendTop = this.bottom - legendHeight - this.padding - 8;
        g.drawRect(this.getSize().width / 2 - this.padding, legendTop - this.fm.getHeight() - this.padding, this.fm.stringWidth(this.legend.longestString()) + 2 * this.padding, legendHeight + 2 * this.padding);
        for (int i = 0; i < this.legend.size(); ++i) {
            g.setColor(this.legend.color(i));
            g.drawString(this.legend.name(i), this.getSize().width / 2, legendTop + i * this.fm.getHeight());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(500, 400);
    }

    public void addItemVector(Vector newItems, String name) {
        this.items.add(newItems);
        this.legend.add(name);
    }

    public void addItem(String name, int value2, Color col) {
        this.items.addElement(new GraphItem(name, value2, col));
    }

    public void addItem(String name, int value2) {
        this.items.addElement(new GraphItem(name, value2, Color.black));
    }

    public void removeItem(String name) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((GraphItem)this.items.elementAt((int)i)).title.equals(name)) continue;
            this.items.removeElementAt(i);
        }
    }

    public class Legend {
        Vector series = new Vector();
        Vector colors = new Vector();

        public void add(String name) {
            this.series.add(name);
            if (this.colors.isEmpty()) {
                this.colors.add(Color.black);
            } else {
                float[] compArray = new float[4];
                Color prevColor = (Color)this.colors.get(this.colors.size() - 1);
                compArray = prevColor.getRGBComponents(compArray);
                compArray[3] = compArray[3] * 0.5f;
                this.colors.add(new Color(compArray[0], compArray[1], compArray[2], compArray[3]));
            }
        }

        public Color color(int i) {
            return (Color)this.colors.get(i);
        }

        public String name(int i) {
            return (String)this.series.get(i);
        }

        public int size() {
            return this.colors.size();
        }

        public String longestString() {
            String longest = new String("");
            for (int i = 0; i < this.series.size(); ++i) {
                String temp = (String)this.series.get(i);
                if (temp.length() <= longest.length()) continue;
                longest = temp;
            }
            return longest;
        }
    }
}

