/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.Boostable;
import cc.mallet.classify.ClassifierTrainer;
import cc.mallet.classify.FeatureConstraintUtil;
import cc.mallet.classify.MaxEnt;
import cc.mallet.classify.MaxEntOptimizableByGE;
import cc.mallet.classify.constraints.ge.MaxEntGEConstraint;
import cc.mallet.classify.constraints.ge.MaxEntRangeL2FLGEConstraints;
import cc.mallet.optimize.LimitedMemoryBFGS;
import cc.mallet.optimize.Optimizable;
import cc.mallet.optimize.Optimizer;
import cc.mallet.types.InstanceList;
import cc.mallet.util.MalletLogger;
import cc.mallet.util.MalletProgressMessageLogger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

public class MaxEntGERangeTrainer
extends ClassifierTrainer<MaxEnt>
implements ClassifierTrainer.ByOptimization<MaxEnt>,
Boostable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = MalletLogger.getLogger(MaxEntGERangeTrainer.class.getName());
    private static Logger progressLogger = MalletProgressMessageLogger.getLogger(MaxEntGERangeTrainer.class.getName() + "-pl");
    private boolean normalize = true;
    private boolean useValues = false;
    private String constraintsFile;
    private int numIterations = 0;
    private int maxIterations = Integer.MAX_VALUE;
    private double temperature = 1.0;
    private double gaussianPriorVariance = 1.0;
    protected ArrayList<MaxEntGEConstraint> constraints;
    private InstanceList trainingList = null;
    private MaxEnt classifier = null;
    private MaxEntOptimizableByGE ge = null;
    private Optimizer opt = null;

    public MaxEntGERangeTrainer() {
    }

    public MaxEntGERangeTrainer(ArrayList<MaxEntGEConstraint> constraints) {
        this.constraints = constraints;
    }

    public MaxEntGERangeTrainer(ArrayList<MaxEntGEConstraint> constraints, MaxEnt classifier) {
        this.constraints = constraints;
        this.classifier = classifier;
    }

    public void setConstraintsFile(String filename) {
        this.constraintsFile = filename;
    }

    public void setTemperature(double temp) {
        this.temperature = temp;
    }

    public void setGaussianPriorVariance(double variance) {
        this.gaussianPriorVariance = variance;
    }

    @Override
    public MaxEnt getClassifier() {
        return this.classifier;
    }

    public void setUseValues(boolean flag) {
        this.useValues = flag;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public Optimizable.ByGradientValue getOptimizable(InstanceList trainingList) {
        if (this.ge == null) {
            this.ge = new MaxEntOptimizableByGE(trainingList, this.constraints, this.classifier);
            this.ge.setTemperature(this.temperature);
            this.ge.setGaussianPriorVariance(this.gaussianPriorVariance);
        }
        return this.ge;
    }

    @Override
    public Optimizer getOptimizer() {
        this.getOptimizable(this.trainingList);
        if (this.opt == null) {
            this.opt = new LimitedMemoryBFGS(this.ge);
        }
        return this.opt;
    }

    public void setOptimizer(Optimizer opt2) {
        this.opt = opt2;
    }

    public void setMaxIterations(int iter2) {
        this.maxIterations = iter2;
    }

    @Override
    public int getIteration() {
        return this.numIterations;
    }

    @Override
    public MaxEnt train(InstanceList trainingList) {
        return this.train(trainingList, this.maxIterations);
    }

    @Override
    public MaxEnt train(InstanceList train, int maxIterations) {
        this.trainingList = train;
        if (this.constraints == null && this.constraintsFile != null) {
            HashMap<Integer, double[][]> constraintsMap = FeatureConstraintUtil.readRangeConstraintsFromFile(this.constraintsFile, this.trainingList);
            logger.info("number of constraints: " + constraintsMap.size());
            this.constraints = new ArrayList();
            MaxEntRangeL2FLGEConstraints geConstraints = new MaxEntRangeL2FLGEConstraints(train.getDataAlphabet().size(), train.getTargetAlphabet().size(), this.useValues, this.normalize);
            for (int fi : constraintsMap.keySet()) {
                double[][] dist = constraintsMap.get(fi);
                for (int li = 0; li < dist.length; ++li) {
                    if (Double.isInfinite(dist[li][0])) continue;
                    geConstraints.addConstraint(fi, li, dist[li][0], dist[li][1], 1.0);
                }
            }
            this.constraints.add(geConstraints);
        }
        this.getOptimizable(this.trainingList);
        this.getOptimizer();
        if (this.opt instanceof LimitedMemoryBFGS) {
            ((LimitedMemoryBFGS)this.opt).reset();
        }
        logger.fine("trainingList.size() = " + this.trainingList.size());
        try {
            this.opt.optimize(maxIterations);
            this.numIterations += maxIterations;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("Catching exception; saying converged.");
        }
        if (maxIterations == Integer.MAX_VALUE && this.opt instanceof LimitedMemoryBFGS) {
            ((LimitedMemoryBFGS)this.opt).reset();
            try {
                this.opt.optimize(maxIterations);
                this.numIterations += maxIterations;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info("Catching exception; saying converged.");
            }
        }
        progressLogger.info("\n");
        this.classifier = this.ge.getClassifier();
        return this.classifier;
    }
}

