/*
 * Decompiled with CFR 0.152.
 */
package bsh.classpath;

import bsh.ClassPathException;
import bsh.NameSource;
import bsh.StringUtil;
import bsh.classpath.ClassPathListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class BshClassPath
implements ClassPathListener,
NameSource {
    String name;
    private List path;
    private List compPaths;
    private Map packageMap;
    private Map classSource;
    private boolean mapsInitialized;
    private UnqualifiedNameTable unqNameTable;
    private boolean nameCompletionIncludesUnqNames = true;
    Vector listeners = new Vector();
    static URL[] userClassPathComp;
    static BshClassPath userClassPath;
    static BshClassPath bootClassPath;
    List nameSourceListeners;
    static MappingFeedback mappingFeedbackListener;
    static /* synthetic */ Class class$java$lang$Class;

    public BshClassPath(String string2) {
        this.name = string2;
        this.reset();
    }

    public BshClassPath(String string2, URL[] uRLArray) {
        this(string2);
        this.add(uRLArray);
    }

    public void setPath(URL[] uRLArray) {
        this.reset();
        this.add(uRLArray);
    }

    public void addComponent(BshClassPath bshClassPath) {
        if (this.compPaths == null) {
            this.compPaths = new ArrayList();
        }
        this.compPaths.add(bshClassPath);
        bshClassPath.addListener(this);
    }

    public void add(URL[] uRLArray) {
        this.path.addAll(Arrays.asList(uRLArray));
        if (this.mapsInitialized) {
            this.map(uRLArray);
        }
    }

    public void add(URL uRL) throws IOException {
        this.path.add(uRL);
        if (this.mapsInitialized) {
            this.map(uRL);
        }
    }

    public URL[] getPathComponents() {
        return this.getFullPath().toArray(new URL[0]);
    }

    public synchronized Set getClassesForPackage(String string2) {
        this.insureInitialized();
        HashSet hashSet = new HashSet();
        Collection collection = (Collection)this.packageMap.get(string2);
        if (collection != null) {
            hashSet.addAll(collection);
        }
        if (this.compPaths != null) {
            int n = 0;
            while (n < this.compPaths.size()) {
                collection = ((BshClassPath)this.compPaths.get(n)).getClassesForPackage(string2);
                if (collection != null) {
                    hashSet.addAll(collection);
                }
                ++n;
            }
        }
        return hashSet;
    }

    public synchronized ClassSource getClassSource(String string2) {
        ClassSource classSource = (ClassSource)this.classSource.get(string2);
        if (classSource != null) {
            return classSource;
        }
        this.insureInitialized();
        classSource = (ClassSource)this.classSource.get(string2);
        if (classSource == null && this.compPaths != null) {
            int n = 0;
            while (n < this.compPaths.size() && classSource == null) {
                classSource = ((BshClassPath)this.compPaths.get(n)).getClassSource(string2);
                ++n;
            }
        }
        return classSource;
    }

    public synchronized void setClassSource(String string2, ClassSource classSource) {
        this.classSource.put(string2, classSource);
    }

    public void insureInitialized() {
        this.insureInitialized(true);
    }

    protected synchronized void insureInitialized(boolean bl) {
        if (bl && !this.mapsInitialized) {
            this.startClassMapping();
        }
        if (this.compPaths != null) {
            int n = 0;
            while (n < this.compPaths.size()) {
                ((BshClassPath)this.compPaths.get(n)).insureInitialized(false);
                ++n;
            }
        }
        if (!this.mapsInitialized) {
            this.map(this.path.toArray(new URL[0]));
        }
        if (bl && !this.mapsInitialized) {
            this.endClassMapping();
        }
        this.mapsInitialized = true;
    }

    protected List getFullPath() {
        ArrayList arrayList = new ArrayList();
        if (this.compPaths != null) {
            int n = 0;
            while (n < this.compPaths.size()) {
                List list2 = ((BshClassPath)this.compPaths.get(n)).getFullPath();
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (arrayList.contains(e)) continue;
                    arrayList.add(e);
                }
                ++n;
            }
        }
        arrayList.addAll(this.path);
        return arrayList;
    }

    public String getClassNameByUnqName(String string2) throws ClassPathException {
        this.insureInitialized();
        UnqualifiedNameTable unqualifiedNameTable = this.getUnqualifiedNameTable();
        Object v = unqualifiedNameTable.get(string2);
        if (v instanceof AmbiguousName) {
            throw new ClassPathException("Ambigous class names: " + ((AmbiguousName)v).get());
        }
        return (String)v;
    }

    private UnqualifiedNameTable getUnqualifiedNameTable() {
        if (this.unqNameTable == null) {
            this.unqNameTable = this.buildUnqualifiedNameTable();
        }
        return this.unqNameTable;
    }

    private UnqualifiedNameTable buildUnqualifiedNameTable() {
        Object object;
        UnqualifiedNameTable unqualifiedNameTable = new UnqualifiedNameTable();
        if (this.compPaths != null) {
            int n = 0;
            while (n < this.compPaths.size()) {
                object = ((BshClassPath)this.compPaths.get((int)n)).classSource.keySet();
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    unqualifiedNameTable.add((String)iterator2.next());
                }
                ++n;
            }
        }
        object = this.classSource.keySet().iterator();
        while (object.hasNext()) {
            unqualifiedNameTable.add((String)object.next());
        }
        return unqualifiedNameTable;
    }

    public String[] getAllNames() {
        this.insureInitialized();
        ArrayList arrayList = new ArrayList();
        Iterator iterator2 = this.getPackagesSet().iterator();
        while (iterator2.hasNext()) {
            String string2 = (String)iterator2.next();
            arrayList.addAll(BshClassPath.removeInnerClassNames(this.getClassesForPackage(string2)));
        }
        if (this.nameCompletionIncludesUnqNames) {
            arrayList.addAll(this.getUnqualifiedNameTable().keySet());
        }
        return arrayList.toArray(new String[0]);
    }

    synchronized void map(URL[] uRLArray) {
        int n = 0;
        while (n < uRLArray.length) {
            try {
                this.map(uRLArray[n]);
            }
            catch (IOException iOException) {
                String string2 = "Error constructing classpath: " + uRLArray[n] + ": " + iOException;
                this.errorWhileMapping(string2);
            }
            ++n;
        }
    }

    synchronized void map(URL uRL) throws IOException {
        String string2 = uRL.getFile();
        File file = new File(string2);
        if (file.isDirectory()) {
            this.classMapping("Directory " + file.toString());
            this.map(BshClassPath.traverseDirForClasses(file), new DirClassSource(file));
        } else if (BshClassPath.isArchiveFileName(string2)) {
            this.classMapping("Archive: " + uRL);
            this.map(BshClassPath.searchJarForClasses(uRL), new JarClassSource(uRL));
        } else {
            String string3 = "Not a classpath component: " + string2;
            this.errorWhileMapping(string3);
        }
    }

    private void map(String[] stringArray, Object object) {
        int n = 0;
        while (n < stringArray.length) {
            this.mapClass(stringArray[n], object);
            ++n;
        }
    }

    private void mapClass(String string2, Object object) {
        String[] stringArray = BshClassPath.splitClassname(string2);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        HashSet<String> hashSet = (HashSet<String>)this.packageMap.get(string3);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            this.packageMap.put(string3, hashSet);
        }
        hashSet.add(string2);
        Object v = this.classSource.get(string2);
        if (v == null) {
            this.classSource.put(string2, object);
        }
    }

    private synchronized void reset() {
        this.path = new ArrayList();
        this.compPaths = null;
        this.clearCachedStructures();
    }

    private synchronized void clearCachedStructures() {
        this.mapsInitialized = false;
        this.packageMap = new HashMap();
        this.classSource = new HashMap();
        this.unqNameTable = null;
        this.nameSpaceChanged();
    }

    public void classPathChanged() {
        this.clearCachedStructures();
        this.notifyListeners();
    }

    static String[] traverseDirForClasses(File file) throws IOException {
        List list2 = BshClassPath.traverseDirForClassesAux(file, file);
        return list2.toArray(new String[0]);
    }

    static List traverseDirForClassesAux(File file, File file2) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = file.getAbsolutePath();
        File[] fileArray = file2.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file3 = fileArray[n];
            if (file3.isDirectory()) {
                arrayList.addAll(BshClassPath.traverseDirForClassesAux(file, file3));
            } else {
                String string3 = file3.getAbsolutePath();
                if (BshClassPath.isClassFileName(string3)) {
                    if (!string3.startsWith(string2)) {
                        throw new IOException("problem parsing paths");
                    }
                    string3 = string3.substring(string2.length() + 1);
                    string3 = BshClassPath.canonicalizeClassName(string3);
                    arrayList.add(string3);
                }
            }
            ++n;
        }
        return arrayList;
    }

    static String[] searchJarForClasses(URL uRL) throws IOException {
        Object[] objectArray;
        ZipEntry zipEntry;
        Vector<String> vector = new Vector<String>();
        InputStream inputStream = uRL.openStream();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            objectArray = zipEntry.getName();
            if (!BshClassPath.isClassFileName((String)objectArray)) continue;
            vector.addElement(BshClassPath.canonicalizeClassName((String)objectArray));
        }
        zipInputStream.close();
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static boolean isClassFileName(String string2) {
        return string2.toLowerCase().endsWith(".class");
    }

    public static boolean isArchiveFileName(String string2) {
        return (string2 = string2.toLowerCase()).endsWith(".jar") || string2.endsWith(".zip");
    }

    public static String canonicalizeClassName(String string2) {
        String string3 = string2.replace('/', '.');
        if ((string3 = string3.replace('\\', '.')).startsWith("class ")) {
            string3 = string3.substring(6);
        }
        if (string3.endsWith(".class")) {
            string3 = string3.substring(0, string3.length() - 6);
        }
        return string3;
    }

    public static String[] splitClassname(String string2) {
        String string3;
        String string4;
        int n = (string2 = BshClassPath.canonicalizeClassName(string2)).lastIndexOf(".");
        if (n == -1) {
            string4 = string2;
            string3 = "<unpackaged>";
        } else {
            string3 = string2.substring(0, n);
            string4 = string2.substring(n + 1);
        }
        return new String[]{string3, string4};
    }

    public static Collection removeInnerClassNames(Collection collection) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(collection);
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            String string2 = (String)iterator2.next();
            if (string2.indexOf("$") == -1) continue;
            iterator2.remove();
        }
        return arrayList;
    }

    public static URL[] getUserClassPathComponents() throws ClassPathException {
        if (userClassPathComp != null) {
            return userClassPathComp;
        }
        String string2 = System.getProperty("java.class.path");
        String[] stringArray = StringUtil.split(string2, File.pathSeparator);
        URL[] uRLArray = new URL[stringArray.length];
        try {
            int n = 0;
            while (n < stringArray.length) {
                uRLArray[n] = new File(new File(stringArray[n]).getCanonicalPath()).toURL();
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new ClassPathException("can't parse class path: " + iOException);
        }
        userClassPathComp = uRLArray;
        return uRLArray;
    }

    public Set getPackagesSet() {
        this.insureInitialized();
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.packageMap.keySet());
        if (this.compPaths != null) {
            int n = 0;
            while (n < this.compPaths.size()) {
                hashSet.addAll(((BshClassPath)this.compPaths.get((int)n)).packageMap.keySet());
                ++n;
            }
        }
        return hashSet;
    }

    public void addListener(ClassPathListener classPathListener) {
        this.listeners.addElement(new WeakReference<ClassPathListener>(classPathListener));
    }

    public void removeListener(ClassPathListener classPathListener) {
        this.listeners.removeElement(classPathListener);
    }

    void notifyListeners() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            WeakReference weakReference = (WeakReference)enumeration.nextElement();
            ClassPathListener classPathListener = (ClassPathListener)weakReference.get();
            if (classPathListener == null) {
                this.listeners.removeElement(weakReference);
                continue;
            }
            classPathListener.classPathChanged();
        }
    }

    public static BshClassPath getUserClassPath() throws ClassPathException {
        if (userClassPath == null) {
            userClassPath = new BshClassPath("User Class Path", BshClassPath.getUserClassPathComponents());
        }
        return userClassPath;
    }

    public static BshClassPath getBootClassPath() throws ClassPathException {
        if (bootClassPath == null) {
            try {
                String string2 = BshClassPath.getRTJarPath();
                URL uRL = new File(string2).toURL();
                bootClassPath = new BshClassPath("Boot Class Path", new URL[]{uRL});
            }
            catch (MalformedURLException malformedURLException) {
                throw new ClassPathException(" can't find boot jar: " + malformedURLException);
            }
        }
        return bootClassPath;
    }

    private static String getRTJarPath() {
        String string2 = (class$java$lang$Class == null ? (class$java$lang$Class = BshClassPath.class$("java.lang.Class")) : class$java$lang$Class).getResource("/java/lang/String.class").toExternalForm();
        if (!string2.startsWith("jar:file:")) {
            return null;
        }
        int n = string2.indexOf("!");
        if (n == -1) {
            return null;
        }
        return string2.substring("jar:file:".length(), n);
    }

    public static void main(String[] stringArray) throws Exception {
        URL[] uRLArray = new URL[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            uRLArray[n] = new File(stringArray[n]).toURL();
            ++n;
        }
        BshClassPath bshClassPath = new BshClassPath("Test", uRLArray);
    }

    public String toString() {
        return "BshClassPath " + this.name + "(" + super.toString() + ") path= " + this.path + "\n" + "compPaths = {" + this.compPaths + " }";
    }

    void nameSpaceChanged() {
        if (this.nameSourceListeners == null) {
            return;
        }
        int n = 0;
        while (n < this.nameSourceListeners.size()) {
            ((NameSource.Listener)this.nameSourceListeners.get(n)).nameSourceChanged(this);
            ++n;
        }
    }

    public void addNameSourceListener(NameSource.Listener listener) {
        if (this.nameSourceListeners == null) {
            this.nameSourceListeners = new ArrayList();
        }
        this.nameSourceListeners.add(listener);
    }

    public static void addMappingFeedback(MappingFeedback mappingFeedback) {
        if (mappingFeedbackListener != null) {
            throw new RuntimeException("Unimplemented: already a listener");
        }
        mappingFeedbackListener = mappingFeedback;
    }

    void startClassMapping() {
        if (mappingFeedbackListener != null) {
            mappingFeedbackListener.startClassMapping();
        } else {
            System.err.println("Start ClassPath Mapping");
        }
    }

    void classMapping(String string2) {
        if (mappingFeedbackListener != null) {
            mappingFeedbackListener.classMapping(string2);
        } else {
            System.err.println("Mapping: " + string2);
        }
    }

    void errorWhileMapping(String string2) {
        if (mappingFeedbackListener != null) {
            mappingFeedbackListener.errorWhileMapping(string2);
        } else {
            System.err.println(string2);
        }
    }

    void endClassMapping() {
        if (mappingFeedbackListener != null) {
            mappingFeedbackListener.endClassMapping();
        } else {
            System.err.println("End ClassPath Mapping");
        }
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface MappingFeedback {
        public void startClassMapping();

        public void classMapping(String var1);

        public void errorWhileMapping(String var1);

        public void endClassMapping();
    }

    public static class AmbiguousName {
        List list = new ArrayList();

        public void add(String string2) {
            this.list.add(string2);
        }

        public List get() {
            return this.list;
        }
    }

    static class UnqualifiedNameTable
    extends HashMap {
        UnqualifiedNameTable() {
        }

        void add(String string2) {
            String string3 = BshClassPath.splitClassname(string2)[1];
            Object v = super.get(string3);
            if (v == null) {
                super.put(string3, string2);
            } else if (v instanceof AmbiguousName) {
                ((AmbiguousName)v).add(string2);
            } else {
                AmbiguousName ambiguousName = new AmbiguousName();
                ambiguousName.add((String)v);
                ambiguousName.add(string2);
                super.put(string3, ambiguousName);
            }
        }
    }

    public static class GeneratedClassSource
    extends ClassSource {
        GeneratedClassSource(byte[] byArray) {
            this.source = byArray;
        }

        public byte[] getCode(String string2) {
            return (byte[])this.source;
        }
    }

    public static class DirClassSource
    extends ClassSource {
        DirClassSource(File file) {
            this.source = file;
        }

        public File getDir() {
            return (File)this.source;
        }

        public String toString() {
            return "Dir: " + this.source;
        }

        public byte[] getCode(String string2) {
            return DirClassSource.readBytesFromFile(this.getDir(), string2);
        }

        public static byte[] readBytesFromFile(File file, String string2) {
            byte[] byArray;
            String string3 = string2.replace('.', File.separatorChar) + ".class";
            File file2 = new File(file, string3);
            if (file2 == null || !file2.exists()) {
                return null;
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                byArray = new byte[(int)file2.length()];
                dataInputStream.readFully(byArray);
                dataInputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Couldn't load file: " + file2);
            }
            return byArray;
        }
    }

    public static class JarClassSource
    extends ClassSource {
        JarClassSource(URL uRL) {
            this.source = uRL;
        }

        public URL getURL() {
            return (URL)this.source;
        }

        public byte[] getCode(String string2) {
            throw new Error("Unimplemented");
        }

        public String toString() {
            return "Jar: " + this.source;
        }
    }

    public static abstract class ClassSource {
        Object source;

        abstract byte[] getCode(String var1);
    }
}

