/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Node;
import bsh.ParserTreeConstants;
import bsh.Token;

class SimpleNode
implements Node {
    public static SimpleNode JAVACODE = new SimpleNode(-1){

        public String getSourceFile() {
            return "<Called from Java Code>";
        }

        public int getLineNumber() {
            return -1;
        }

        public String getText() {
            return "<Compiled Java Code>";
        }
    };
    protected Node parent;
    protected Node[] children;
    protected int id;
    Token firstToken;
    Token lastToken;
    String sourceFile;

    public SimpleNode(int n) {
        this.id = n;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public SimpleNode getChild(int n) {
        return (SimpleNode)this.jjtGetChild(n);
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return ParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string2) {
        return string2 + this.toString();
    }

    public void dump(String string2) {
        System.out.println(this.toString(string2));
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(string2 + " ");
                }
                ++n;
            }
        }
    }

    public void prune() {
        this.jjtSetParent(null);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        throw new InterpreterError("Unimplemented or inappropriate for " + this.getClass().getName());
    }

    public void setSourceFile(String string2) {
        this.sourceFile = string2;
    }

    public String getSourceFile() {
        if (this.sourceFile == null) {
            if (this.parent != null) {
                return ((SimpleNode)this.parent).getSourceFile();
            }
            return "<unknown file>";
        }
        return this.sourceFile;
    }

    public int getLineNumber() {
        return this.firstToken.beginLine;
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        Token token2 = this.firstToken;
        while (token2 != null) {
            stringBuffer.append(token2.image);
            if (!token2.image.equals(".")) {
                stringBuffer.append(" ");
            }
            if (token2 == this.lastToken || token2.image.equals("{") || token2.image.equals(";")) break;
            token2 = token2.next;
        }
        return stringBuffer.toString();
    }
}

