/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;

public class Remote {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("usage: Remote URL(http|bsh) file [ file ] ... ");
            System.exit(1);
        }
        String string2 = stringArray[0];
        String string3 = Remote.getFile(stringArray[1]);
        int n = Remote.eval(string2, string3);
        System.exit(n);
    }

    public static int eval(String string2, String string3) throws IOException {
        String string4 = null;
        if (string2.startsWith("http:")) {
            string4 = Remote.doHttp(string2, string3);
        } else if (string2.startsWith("bsh:")) {
            string4 = Remote.doBsh(string2, string3);
        } else {
            throw new IOException("Unrecognized URL type.Scheme must be http:// or bsh://");
        }
        try {
            return Integer.parseInt(string4);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    static String doBsh(String string2, String string3) {
        String string4 = "";
        String string5 = "";
        String string6 = "-1";
        String string7 = string2;
        try {
            string2 = string2.substring(6);
            int n = string2.indexOf(":");
            string4 = string2.substring(0, n);
            string5 = string2.substring(n + 1, string2.length());
        }
        catch (Exception exception) {
            System.err.println("Bad URL: " + string7 + ": " + exception);
            return string6;
        }
        try {
            String string8;
            System.out.println("Connecting to host : " + string4 + " at port : " + string5);
            Socket socket = new Socket(string4, Integer.parseInt(string5) + 1);
            OutputStream outputStream = socket.getOutputStream();
            InputStream inputStream = socket.getInputStream();
            Remote.sendLine(string3, outputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string8 = bufferedReader.readLine()) != null) {
                System.out.println(string8);
            }
            string6 = "1";
            return string6;
        }
        catch (Exception exception) {
            System.err.println("Error communicating with server: " + exception);
            return string6;
        }
    }

    private static void sendLine(String string2, OutputStream outputStream) throws IOException {
        outputStream.write(string2.getBytes());
        outputStream.flush();
    }

    static String doHttp(String string2, String string3) {
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("bsh.client=Remote");
        stringBuffer.append("&bsh.script=");
        stringBuffer.append(URLEncoder.encode(string3));
        String string5 = stringBuffer.toString();
        try {
            String string6;
            URL uRL = new URL(string2);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(httpURLConnection.getOutputStream(), "8859_1"), true);
            printWriter.print(string5);
            printWriter.flush();
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                System.out.println("Error, HTTP response: " + n);
            }
            string4 = httpURLConnection.getHeaderField("Bsh-Return");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            while ((string6 = bufferedReader.readLine()) != null) {
                System.out.println(string6);
            }
            System.out.println("Return Value: " + string4);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        return string4;
    }

    static String getFile(String string2) throws FileNotFoundException, IOException {
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
        while ((string3 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string3).append("\n");
        }
        return stringBuffer.toString();
    }
}

