/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Name;
import bsh.UtilEvalError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Hashtable;

public class BshClassManager {
    private static Object NOVALUE = new Object();
    private Interpreter declaringInterpreter;
    protected ClassLoader externalClassLoader;
    protected transient Hashtable absoluteClassCache = new Hashtable();
    protected transient Hashtable absoluteNonClasses = new Hashtable();
    protected transient Hashtable resolvedObjectMethods = new Hashtable();
    protected transient Hashtable resolvedStaticMethods = new Hashtable();
    protected transient Hashtable definingClasses = new Hashtable();
    protected transient Hashtable definingClassesBaseNames = new Hashtable();
    static /* synthetic */ Class class$bsh$Interpreter;

    public static BshClassManager createClassManager(Interpreter interpreter) {
        BshClassManager bshClassManager;
        if (Capabilities.classExists("java.lang.ref.WeakReference") && Capabilities.classExists("java.util.HashMap") && Capabilities.classExists("bsh.classpath.ClassManagerImpl")) {
            try {
                Class<?> clazz = Class.forName("bsh.classpath.ClassManagerImpl");
                bshClassManager = (BshClassManager)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new InterpreterError("Error loading classmanager: " + exception);
            }
        } else {
            bshClassManager = new BshClassManager();
        }
        if (interpreter == null) {
            interpreter = new Interpreter();
        }
        bshClassManager.declaringInterpreter = interpreter;
        return bshClassManager;
    }

    public boolean classExists(String string2) {
        return this.classForName(string2) != null;
    }

    public Class classForName(String string2) {
        if (this.isClassBeingDefined(string2)) {
            throw new InterpreterError("Attempting to load class in the process of being defined: " + string2);
        }
        Class clazz = null;
        try {
            clazz = this.plainClassForName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = this.loadSourceClass(string2);
        }
        return clazz;
    }

    protected Class loadSourceClass(String string2) {
        String string3 = "/" + string2.replace('.', '/') + ".java";
        InputStream inputStream = this.getResourceAsStream(string3);
        if (inputStream == null) {
            return null;
        }
        try {
            System.out.println("Loading class from source file: " + string3);
            this.declaringInterpreter.eval(new InputStreamReader(inputStream));
        }
        catch (EvalError evalError) {
            System.err.println(evalError);
        }
        try {
            return this.plainClassForName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found in source file: " + string2);
            return null;
        }
    }

    public Class plainClassForName(String string2) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = this.externalClassLoader != null ? this.externalClassLoader.loadClass(string2) : Class.forName(string2);
            this.cacheClassInfo(string2, clazz);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw BshClassManager.noClassDefFound(string2, noClassDefFoundError);
        }
        return clazz;
    }

    public URL getResource(String string2) {
        URL uRL = null;
        if (this.externalClassLoader != null) {
            uRL = this.externalClassLoader.getResource(string2.substring(1));
        }
        if (uRL == null) {
            uRL = (class$bsh$Interpreter == null ? (class$bsh$Interpreter = BshClassManager.class$("bsh.Interpreter")) : class$bsh$Interpreter).getResource(string2);
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string2) {
        InputStream inputStream = null;
        if (this.externalClassLoader != null) {
            inputStream = this.externalClassLoader.getResourceAsStream(string2.substring(1));
        }
        if (inputStream == null) {
            inputStream = (class$bsh$Interpreter == null ? (class$bsh$Interpreter = BshClassManager.class$("bsh.Interpreter")) : class$bsh$Interpreter).getResourceAsStream(string2);
        }
        return inputStream;
    }

    public void cacheClassInfo(String string2, Class clazz) {
        if (clazz != null) {
            this.absoluteClassCache.put(string2, clazz);
        } else {
            this.absoluteNonClasses.put(string2, NOVALUE);
        }
    }

    public void cacheResolvedMethod(Class clazz, Class[] classArray, Method method) {
        if (Interpreter.DEBUG) {
            Interpreter.debug("cacheResolvedMethod putting: " + clazz + " " + method);
        }
        SignatureKey signatureKey = new SignatureKey(clazz, method.getName(), classArray);
        if (Modifier.isStatic(method.getModifiers())) {
            this.resolvedStaticMethods.put(signatureKey, method);
        } else {
            this.resolvedObjectMethods.put(signatureKey, method);
        }
    }

    protected Method getResolvedMethod(Class clazz, String string2, Class[] classArray, boolean bl) {
        SignatureKey signatureKey = new SignatureKey(clazz, string2, classArray);
        Method method = (Method)this.resolvedStaticMethods.get(signatureKey);
        if (method == null && !bl) {
            method = (Method)this.resolvedObjectMethods.get(signatureKey);
        }
        if (Interpreter.DEBUG) {
            if (method == null) {
                Interpreter.debug("getResolvedMethod cache MISS: " + clazz + " - " + string2);
            } else {
                Interpreter.debug("getResolvedMethod cache HIT: " + clazz + " - " + method);
            }
        }
        return method;
    }

    protected void clearCaches() {
        this.absoluteNonClasses = new Hashtable();
        this.absoluteClassCache = new Hashtable();
        this.resolvedObjectMethods = new Hashtable();
        this.resolvedStaticMethods = new Hashtable();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.externalClassLoader = classLoader;
        this.classLoaderChanged();
    }

    public void addClassPath(URL uRL) throws IOException {
    }

    public void reset() {
        this.clearCaches();
    }

    public void setClassPath(URL[] uRLArray) throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    public void reloadAllClasses() throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    public void reloadClasses(String[] stringArray) throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    public void reloadPackage(String string2) throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    protected void doSuperImport() throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    protected boolean hasSuperImport() {
        return false;
    }

    protected String getClassNameByUnqName(String string2) throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    public void addListener(Listener listener) {
    }

    public void removeListener(Listener listener) {
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("BshClassManager: no class manager.");
    }

    protected void definingClass(String string2) {
        String string3;
        String string4 = Name.suffix(string2, 1);
        int n = string4.indexOf("$");
        if (n != -1) {
            string4 = string4.substring(n + 1);
        }
        if ((string3 = (String)this.definingClassesBaseNames.get(string4)) != null) {
            throw new InterpreterError("Defining class problem: " + string2 + ": BeanShell cannot yet simultaneously define two or more " + "dependant classes of the same name.  Attempt to define: " + string2 + " while defining: " + string3);
        }
        this.definingClasses.put(string2, NOVALUE);
        this.definingClassesBaseNames.put(string4, string2);
    }

    protected boolean isClassBeingDefined(String string2) {
        return this.definingClasses.get(string2) != null;
    }

    protected String getClassBeingDefined(String string2) {
        String string3 = Name.suffix(string2, 1);
        return (String)this.definingClassesBaseNames.get(string3);
    }

    protected void doneDefiningClass(String string2) {
        String string3 = Name.suffix(string2, 1);
        this.definingClasses.remove(string2);
        this.definingClassesBaseNames.remove(string3);
    }

    public Class defineClass(String string2, byte[] byArray) {
        throw new InterpreterError("Can't create class (" + string2 + ") without class manager package.");
    }

    protected void classLoaderChanged() {
    }

    protected static Error noClassDefFound(String string2, Error error) {
        return new NoClassDefFoundError("A class required by class: " + string2 + " could not be loaded:\n" + error.toString());
    }

    protected static UtilEvalError cmUnavailable() {
        return new Capabilities.Unavailable("ClassLoading features unavailable.");
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class SignatureKey {
        Class clas;
        Class[] types;
        String methodName;
        int hashCode = 0;

        SignatureKey(Class clazz, String string2, Class[] classArray) {
            this.clas = clazz;
            this.methodName = string2;
            this.types = classArray;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = this.clas.hashCode() * this.methodName.hashCode();
                if (this.types == null) {
                    return this.hashCode;
                }
                int n = 0;
                while (n < this.types.length) {
                    int n2 = this.types[n] == null ? 21 : this.types[n].hashCode();
                    this.hashCode = this.hashCode * (n + 1) + n2;
                    ++n;
                }
            }
            return this.hashCode;
        }

        public boolean equals(Object object) {
            SignatureKey signatureKey = (SignatureKey)object;
            if (this.types == null) {
                return signatureKey.types == null;
            }
            if (this.clas != signatureKey.clas) {
                return false;
            }
            if (!this.methodName.equals(signatureKey.methodName)) {
                return false;
            }
            if (this.types.length != signatureKey.types.length) {
                return false;
            }
            int n = 0;
            while (n < this.types.length) {
                if (this.types[n] == null ? signatureKey.types[n] != null : !this.types[n].equals(signatureKey.types[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }

    public static interface Listener {
        public void classLoaderChanged();
    }
}

