/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHPrimitiveType;
import bsh.BshClassManager;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Name;
import bsh.SimpleNode;
import java.lang.reflect.Array;

class BSHType
extends SimpleNode
implements BshClassManager.Listener {
    private Class baseType;
    private int arrayDims;
    private Class type;
    String descriptor;

    BSHType(int n) {
        super(n);
    }

    public void addArrayDimension() {
        ++this.arrayDims;
    }

    SimpleNode getTypeNode() {
        return (SimpleNode)this.jjtGetChild(0);
    }

    public String getTypeDescriptor(CallStack callStack, Interpreter interpreter, String string2) {
        String string3;
        if (this.descriptor != null) {
            return this.descriptor;
        }
        SimpleNode simpleNode = this.getTypeNode();
        if (simpleNode instanceof BSHPrimitiveType) {
            string3 = BSHType.getTypeDescriptor(((BSHPrimitiveType)simpleNode).type);
        } else {
            String string4 = ((BSHAmbiguousName)simpleNode).text;
            BshClassManager bshClassManager = interpreter.getClassManager();
            String string5 = bshClassManager.getClassBeingDefined(string4);
            Class clazz = null;
            if (string5 == null) {
                try {
                    clazz = ((BSHAmbiguousName)simpleNode).toClass(callStack, interpreter);
                }
                catch (EvalError evalError) {}
            } else {
                string4 = string5;
            }
            string3 = clazz != null ? BSHType.getTypeDescriptor(clazz) : (string2 == null || Name.isCompound(string4) ? "L" + string4.replace('.', '/') + ";" : "L" + string2.replace('.', '/') + "/" + string4 + ";");
        }
        int n = 0;
        while (n < this.arrayDims) {
            string3 = "[" + string3;
            ++n;
        }
        this.descriptor = string3;
        return string3;
    }

    public Class getType(CallStack callStack, Interpreter interpreter) throws EvalError {
        if (this.type != null) {
            return this.type;
        }
        SimpleNode simpleNode = this.getTypeNode();
        this.baseType = simpleNode instanceof BSHPrimitiveType ? ((BSHPrimitiveType)simpleNode).getType() : ((BSHAmbiguousName)simpleNode).toClass(callStack, interpreter);
        if (this.arrayDims > 0) {
            try {
                int[] nArray = new int[this.arrayDims];
                Object object = Array.newInstance(this.baseType, nArray);
                this.type = object.getClass();
            }
            catch (Exception exception) {
                throw new EvalError("Couldn't construct array type", this, callStack);
            }
        } else {
            this.type = this.baseType;
        }
        interpreter.getClassManager().addListener(this);
        return this.type;
    }

    public Class getBaseType() {
        return this.baseType;
    }

    public int getArrayDims() {
        return this.arrayDims;
    }

    public void classLoaderChanged() {
        this.type = null;
        this.baseType = null;
    }

    public static String getTypeDescriptor(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        if (clazz == Void.TYPE) {
            return "V";
        }
        String string2 = clazz.getName().replace('.', '/');
        if (string2.startsWith("[") || string2.endsWith(";")) {
            return string2;
        }
        return "L" + string2.replace('.', '/') + ";";
    }
}

