/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Primitive;
import bsh.SimpleNode;

class BSHLiteral
extends SimpleNode {
    public Object value;

    BSHLiteral(int n) {
        super(n);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        if (this.value == null) {
            throw new InterpreterError("Null in bsh literal: " + this.value);
        }
        return this.value;
    }

    private char getEscapeChar(char c) {
        switch (c) {
            case 'b': {
                c = (char)8;
                break;
            }
            case 't': {
                c = (char)9;
                break;
            }
            case 'n': {
                c = (char)10;
                break;
            }
            case 'f': {
                c = (char)12;
                break;
            }
            case 'r': {
                c = (char)13;
                break;
            }
        }
        return c;
    }

    public void charSetup(String string2) {
        char c = string2.charAt(0);
        if (c == '\\') {
            c = string2.charAt(1);
            c = Character.isDigit(c) ? (char)Integer.parseInt(string2.substring(1), 8) : this.getEscapeChar(c);
        }
        this.value = new Primitive(new Character(c).charValue());
    }

    void stringSetup(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (c == '\\') {
                if (Character.isDigit(c = string2.charAt(++n))) {
                    int n2 = n;
                    while (n2 < n + 2) {
                        if (!Character.isDigit(string2.charAt(n2 + 1))) break;
                        ++n2;
                    }
                    c = (char)Integer.parseInt(string2.substring(n, n2 + 1), 8);
                    n = n2;
                } else {
                    c = this.getEscapeChar(c);
                }
            }
            stringBuffer.append(c);
            ++n;
        }
        this.value = stringBuffer.toString().intern();
    }
}

