/*
 * Decompiled with CFR 0.152.
 */
package banner.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Trie<K, V> {
    private V value;
    private Map<K, Trie<K, V>> children;

    public Trie() {
        this(null);
    }

    public Trie(V value2) {
        this.value = value2;
        this.children = null;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value2) {
        this.value = value2;
    }

    public V add(List<K> keys, V value2) {
        Trie<K, V> current = this;
        Iterator<K> keyIterator = keys.iterator();
        while (current != null && keyIterator.hasNext()) {
            Trie<K, V> next2;
            K nextKey = keyIterator.next();
            if (current.children == null) {
                current.children = new HashMap<K, Trie<K, V>>(1);
            }
            if ((next2 = current.children.get(nextKey)) == null) {
                next2 = new Trie<K, V>();
                current.children.put(nextKey, next2);
            }
            current = next2;
        }
        V old = current.value;
        current.value = value2;
        return old;
    }

    public Trie<K, V> getChild(K key) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(key);
    }

    public V getValue(List<K> keys) {
        Trie<K, V> current = this;
        Iterator<K> keyIterator = keys.iterator();
        while (current != null && keyIterator.hasNext()) {
            K nextKey = keyIterator.next();
            current = current.children == null ? null : current.children.get(nextKey);
        }
        if (current == null) {
            return null;
        }
        return current.getValue();
    }

    public int size() {
        int size2 = 0;
        if (this.value != null) {
            ++size2;
        }
        if (this.children != null) {
            for (Trie<K, V> child : this.children.values()) {
                size2 += child.size();
            }
        }
        return size2;
    }
}

