/*
 * Decompiled with CFR 0.152.
 */
package banner.types;

import banner.types.Sentence;

public class Token
implements Comparable<Token> {
    private Sentence sentence;
    private int start;
    private int end;

    public Token(Sentence sentence, int start, int end) {
        if (sentence == null) {
            throw new IllegalArgumentException();
        }
        if (start < 0) {
            throw new IllegalArgumentException("Start may not be less than 0: " + start);
        }
        this.sentence = sentence;
        this.start = start;
        this.end = end;
        if (this.length() < 1) {
            throw new IllegalArgumentException("End must be greater than start; start: " + start + " end: " + end);
        }
    }

    public Sentence getSentence() {
        return this.sentence;
    }

    public String getText() {
        return this.sentence.getText(this.start, this.end);
    }

    public int getStart() {
        return this.getStart(false);
    }

    public int getEnd() {
        return this.getEnd(false);
    }

    public int getStart(boolean ignoreWhitespace) {
        int value2 = this.start;
        if (ignoreWhitespace) {
            value2 -= this.sentence.countWhitespace(this.start);
        }
        return value2;
    }

    public int getEnd(boolean ignoreWhitespace) {
        int value2 = this.end;
        if (ignoreWhitespace) {
            value2 -= this.sentence.countWhitespace(this.end) - 1;
        }
        return value2;
    }

    public boolean contains(int index) {
        return index >= this.start && index < this.end;
    }

    public int length() {
        return this.end - this.start;
    }

    public int hashCode() {
        int PRIME = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.sentence.hashCode();
        result2 = 31 * result2 + this.start;
        result2 = 31 * result2 + this.end;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Token other = (Token)obj;
        if (!this.sentence.equals(other.sentence)) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return this.end == other.end;
    }

    @Override
    public int compareTo(Token token2) {
        Integer compare = token2.start - this.start;
        if (compare != 0) {
            return compare;
        }
        return token2.end - this.end;
    }

    public String toString() {
        return this.sentence.getText(this.start, this.end);
    }
}

