/*
 * Decompiled with CFR 0.152.
 */
package banner.types;

import banner.tagging.TagFormat;
import banner.tagging.TagPosition;
import banner.types.EntityIdentification;
import banner.types.EntityType;
import banner.types.Mention;
import banner.types.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Sentence {
    private String sentenceId;
    private String documentId;
    private String text;
    private List<Token> tokens;
    private List<Mention> mentions;
    private Map<Mention, EntityIdentification> identifications;

    public Sentence(String sentenceId, String documentId, String text2) {
        if (sentenceId == null) {
            throw new IllegalArgumentException("sentenceId cannot be null");
        }
        this.sentenceId = sentenceId;
        this.documentId = documentId;
        if (text2 == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if ((text2 = text2.trim()).length() == 0) {
            throw new IllegalArgumentException("Text must have length greater than 0");
        }
        this.text = text2;
        this.tokens = new ArrayList<Token>();
        this.mentions = new ArrayList<Mention>();
        this.identifications = new HashMap<Mention, EntityIdentification>();
    }

    public void addToken(Token token2) {
        if (!token2.getSentence().equals(this)) {
            throw new IllegalArgumentException();
        }
        if (!this.tokens.contains(token2)) {
            this.tokens.add(token2);
        }
    }

    public int countWhitespace(int index) {
        int count2 = 0;
        index = Math.min(index, this.text.length());
        int i = 0;
        while (i < index) {
            if (Character.isWhitespace(this.text.charAt(i))) {
                ++count2;
            }
            ++i;
        }
        return count2;
    }

    public boolean addMention(Mention mention) {
        if (!mention.getSentence().equals(this)) {
            throw new IllegalArgumentException();
        }
        for (Mention previous : this.mentions) {
            if (!previous.equals(mention) || mention.getProbability() == null) continue;
            if (previous.getProbability() == null || mention.getProbability() > previous.getProbability()) {
                previous.setProbability(mention.getProbability());
            }
            return false;
        }
        return this.mentions.add(mention);
    }

    public boolean removeMention(Mention mention) {
        return this.mentions.remove(mention);
    }

    public void addMentions(List<String> tags, double probability) {
        int size2 = tags.size();
        if (size2 != this.tokens.size()) {
            throw new IllegalArgumentException();
        }
        int startIndex = -1;
        EntityType lastType = null;
        EntityType currentType = null;
        int i = 0;
        while (i < size2) {
            Mention mention;
            String[] split2 = tags.get(i).split("-");
            TagPosition position = TagPosition.valueOf(split2[0]);
            lastType = currentType;
            if (split2.length == 2) {
                currentType = EntityType.getType(split2[1]);
            }
            if (split2.length > 2) {
                throw new IllegalArgumentException("Bad tag: " + tags.get(i));
            }
            if (position == TagPosition.O) {
                if (startIndex != -1) {
                    mention = new Mention(this, startIndex, i, lastType, Mention.MentionType.Found, probability);
                    this.addMention(mention);
                }
                startIndex = -1;
            } else if (position == TagPosition.B) {
                if (startIndex != -1) {
                    mention = new Mention(this, startIndex, i, lastType, Mention.MentionType.Found, probability);
                    this.addMention(mention);
                }
                startIndex = i;
            } else if (position == TagPosition.W) {
                if (startIndex != -1) {
                    mention = new Mention(this, startIndex, i, lastType, Mention.MentionType.Found, probability);
                    this.addMention(mention);
                }
                startIndex = i;
            } else if (startIndex == -1) {
                startIndex = i;
            }
            ++i;
        }
        if (startIndex != -1) {
            Mention mention = new Mention(this, startIndex, size2, currentType, Mention.MentionType.Found, probability);
            this.addMention(mention);
        }
    }

    public String getSentenceId() {
        return this.sentenceId;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getText() {
        return this.text;
    }

    public int getTokenIndex(int charIndex, boolean returnNextIfBoundary) {
        int startToken = -1;
        int endToken = -1;
        int i = 0;
        while (i < this.tokens.size()) {
            Token token2 = this.tokens.get(i);
            if (token2.getStart() <= charIndex && (startToken == -1 || this.tokens.get(startToken).getStart() <= token2.getStart())) {
                startToken = i;
            }
            if (token2.getEnd() > charIndex && (endToken == -1 || this.tokens.get(endToken).getEnd() > token2.getEnd())) {
                endToken = i;
            }
            ++i;
        }
        if (returnNextIfBoundary) {
            return startToken;
        }
        return endToken;
    }

    public String getText(int start, int end) {
        return this.text.substring(start, end);
    }

    public List<Token> getTokens() {
        return Collections.unmodifiableList(this.tokens);
    }

    public List<Mention> getMentions() {
        return Collections.unmodifiableList(this.mentions);
    }

    public List<Mention> getMentions(Mention.MentionType mentionType) {
        ArrayList<Mention> mentions2 = new ArrayList<Mention>();
        for (Mention mention : this.mentions) {
            if (!mention.getMentionType().equals((Object)mentionType)) continue;
            mentions2.add(mention);
        }
        return Collections.unmodifiableList(mentions2);
    }

    public List<String> getTokenLabels(TagFormat format2, Set<Mention.MentionType> mentionTypes, OverlapOption sameType, OverlapOption differentType) {
        ArrayList<String> labels = new ArrayList<String>();
        if (sameType.equals((Object)OverlapOption.Exception)) {
            if (!differentType.equals((Object)OverlapOption.Exception)) {
                throw new IllegalArgumentException("Not implemented");
            }
            int i = 0;
            while (i < this.tokens.size()) {
                List<Mention> tokenMentions = this.getMentions(this.tokens.get(i), mentionTypes);
                if (tokenMentions.size() == 0) {
                    labels.add(TagPosition.O.name());
                } else if (tokenMentions.size() == 1) {
                    labels.add(TagPosition.getPositionText(format2, tokenMentions.get(0), i));
                } else {
                    throw new IllegalArgumentException("Sentence " + this.sentenceId + " contains overlapping mentions");
                }
                ++i;
            }
        } else if (sameType.equals((Object)OverlapOption.Union)) {
            if (!differentType.equals((Object)OverlapOption.Exception)) {
                throw new IllegalArgumentException("Not implemented");
            }
            Sentence union2 = this.copy(true, true);
            HashSet<Mention> handledMentions = new HashSet<Mention>();
            HashSet<Mention> unhandledMentions = new HashSet<Mention>(union2.mentions);
            while (unhandledMentions.size() > 0) {
                Mention mention = (Mention)unhandledMentions.iterator().next();
                handledMentions.add(mention);
                if (mentionTypes.contains((Object)mention.getMentionType())) {
                    HashSet<Mention> overlapping = new HashSet<Mention>();
                    for (Mention mention2 : union2.mentions) {
                        if (!mention.overlaps(mention2) || !mention.getEntityType().equals(mention2.getEntityType())) continue;
                        overlapping.add(mention2);
                    }
                    if (overlapping.size() > 1) {
                        int start = Integer.MAX_VALUE;
                        int end = Integer.MIN_VALUE;
                        for (Mention mention2 : overlapping) {
                            start = Math.min(start, mention2.getStart());
                            end = Math.max(end, mention2.getEnd());
                            union2.removeMention(mention2);
                        }
                        union2.addMention(new Mention(union2, start, end, mention.getEntityType(), mention.getMentionType()));
                    }
                }
                unhandledMentions = new HashSet<Mention>(union2.getMentions());
                unhandledMentions.removeAll(handledMentions);
            }
            int i = 0;
            while (i < this.tokens.size()) {
                List<Mention> tokenMentions = union2.getMentions(union2.tokens.get(i), mentionTypes);
                if (tokenMentions.size() == 0) {
                    labels.add(TagPosition.O.name());
                } else if (tokenMentions.size() == 1) {
                    labels.add(TagPosition.getPositionText(format2, tokenMentions.get(0), i));
                } else {
                    throw new IllegalArgumentException("Sentence " + this.sentenceId + " contains overlapping mentions");
                }
                ++i;
            }
        } else if (sameType.equals((Object)OverlapOption.Raw)) {
            if (!differentType.equals((Object)OverlapOption.Raw)) {
                throw new IllegalArgumentException("Not implemented");
            }
            int i = 0;
            while (i < this.tokens.size()) {
                List<Mention> tokenMentions = this.getMentions(this.tokens.get(i), mentionTypes);
                if (tokenMentions.size() == 0) {
                    labels.add(TagPosition.O.name());
                } else if (tokenMentions.size() == 1) {
                    labels.add(TagPosition.getPositionText(format2, tokenMentions.get(0), i));
                } else {
                    StringBuilder label = new StringBuilder();
                    Iterator<Mention> mentionIterator = tokenMentions.iterator();
                    label.append(mentionIterator.next());
                    while (mentionIterator.hasNext()) {
                        label.append("&");
                        label.append(mentionIterator.next());
                    }
                    labels.add(label.toString());
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Not implemented");
        }
        return Collections.unmodifiableList(labels);
    }

    public List<Mention> getMentions(Token token2, Set<Mention.MentionType> mentionTypes) {
        ArrayList<Mention> mentionsForToken = new ArrayList<Mention>();
        for (Mention mention : this.mentions) {
            if (!mentionTypes.contains((Object)mention.getMentionType()) || !mention.getTokens().contains(token2)) continue;
            mentionsForToken.add(mention);
        }
        return Collections.unmodifiableList(mentionsForToken);
    }

    public EntityIdentification setIdentification(Mention mention, EntityIdentification identification) {
        if (!mention.getSentence().equals(this)) {
            throw new IllegalArgumentException();
        }
        return this.identifications.put(mention, identification);
    }

    public EntityIdentification getIdentification(Mention mention) {
        return this.identifications.get(mention);
    }

    public Sentence copy(boolean includeTokens, boolean includeMentions) {
        Sentence sentence2 = new Sentence(this.sentenceId, this.documentId, this.text);
        if (includeTokens) {
            for (Token token2 : this.tokens) {
                sentence2.tokens.add(new Token(sentence2, token2.getStart(), token2.getEnd()));
            }
        }
        if (includeMentions) {
            for (Mention mention : this.mentions) {
                sentence2.mentions.add(mention.copy(sentence2));
            }
        }
        return sentence2;
    }

    public int hashCode() {
        int PRIME = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.sentenceId.hashCode();
        result2 = 31 * result2 + (this.documentId == null ? 0 : this.documentId.hashCode());
        result2 = 31 * result2 + this.text.hashCode();
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sentence other = (Sentence)obj;
        if (!this.sentenceId.equals(other.sentenceId)) {
            return false;
        }
        if (this.documentId == null ? other.documentId != null : !this.documentId.equals(other.documentId)) {
            return false;
        }
        return this.text.equals(other.text);
    }

    public static enum OverlapOption {
        Exception,
        Union,
        Intersection,
        LayerInsideOut,
        LayerOutsideIn,
        LeftToRight,
        AsSet,
        Raw;

    }
}

