/*
 * Decompiled with CFR 0.152.
 */
package banner.types;

import banner.types.EntityType;
import banner.types.Sentence;
import banner.types.Token;
import java.util.List;

public class Mention
implements Comparable<Mention> {
    private Sentence sentence;
    private int start;
    private int end;
    private EntityType entityType;
    private MentionType mentionType;
    private Double probability;

    public Mention(Sentence sentence, int start, int end, EntityType entityType, MentionType mentionType) {
        this(sentence, start, end, entityType, mentionType, null);
    }

    public Mention(Sentence sentence, int start, int end, EntityType entityType, MentionType mentionType, Double probability) {
        if (sentence == null) {
            throw new IllegalArgumentException();
        }
        this.sentence = sentence;
        if (start < 0 || start >= sentence.getTokens().size()) {
            throw new IllegalArgumentException();
        }
        this.start = start;
        if (end <= 0 || end > sentence.getTokens().size()) {
            throw new IllegalArgumentException();
        }
        this.end = end;
        if (this.length() <= 0) {
            throw new IllegalArgumentException("Illegal length - start: " + start + " end: " + end);
        }
        if (entityType == null) {
            throw new IllegalArgumentException();
        }
        this.entityType = entityType;
        if (mentionType == null) {
            throw new IllegalArgumentException();
        }
        this.mentionType = mentionType;
        this.setProbability(probability);
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public MentionType getMentionType() {
        return this.mentionType;
    }

    public Sentence getSentence() {
        return this.sentence;
    }

    public List<Token> getTokens() {
        return this.sentence.getTokens().subList(this.start, this.end);
    }

    public int length() {
        return this.end - this.start;
    }

    public String getText() {
        return this.sentence.getText(this.getStartChar(), this.getEndChar());
    }

    public boolean contains(int tokenIndex) {
        return tokenIndex >= this.start && tokenIndex < this.end;
    }

    public int getEnd() {
        return this.end;
    }

    public int getStart() {
        return this.start;
    }

    public int getStartChar() {
        return this.sentence.getTokens().get(this.start).getStart(false);
    }

    public int getEndChar() {
        return this.sentence.getTokens().get(this.end - 1).getEnd(false);
    }

    public int getStartChar(boolean ignoreWhitespace) {
        return this.sentence.getTokens().get(this.start).getStart(ignoreWhitespace);
    }

    public int getEndChar(boolean ignoreWhitespace) {
        return this.sentence.getTokens().get(this.end - 1).getEnd(ignoreWhitespace);
    }

    public boolean overlaps(Mention mention2) {
        return this.sentence.equals(mention2.sentence) && this.end > mention2.start && this.start < mention2.end;
    }

    public Double getProbability() {
        return this.probability;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProbability(Double probability) {
        if (this.mentionType.equals((Object)MentionType.Found)) {
            if (probability != null) {
                if (probability <= 0.0) {
                    throw new IllegalArgumentException("Probability must be greater than 0.0: " + probability);
                }
                if (probability > 1.0) {
                    if (!(probability < 1.000001)) throw new IllegalArgumentException("Probability may not exceed 1.0: " + probability);
                    probability = 1.0;
                }
            }
        } else if (probability != null) {
            throw new IllegalArgumentException();
        }
        this.probability = probability;
    }

    public Mention copy(Sentence sentence2) {
        return new Mention(sentence2, this.start, this.end, this.entityType, this.mentionType, this.probability);
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("Mention text=\"" + this.getText());
        result2.append("\" start=" + this.start);
        result2.append(" end=" + this.end);
        result2.append(" type=" + this.entityType.getText());
        result2.append(" prob=" + this.probability);
        return result2.toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.end;
        result2 = 31 * result2 + this.sentence.hashCode();
        result2 = 31 * result2 + this.start;
        result2 = 31 * result2 + this.entityType.hashCode();
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mention other = (Mention)obj;
        if (!this.sentence.equals(other.sentence)) {
            return false;
        }
        if (!this.entityType.equals(other.entityType)) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return this.end == other.end;
    }

    @Override
    public int compareTo(Mention mention2) {
        Integer compare = this.start - mention2.start;
        if (compare != 0) {
            return compare;
        }
        compare = this.end - mention2.end;
        if (compare != 0) {
            return compare;
        }
        return this.entityType.getText().compareTo(mention2.entityType.getText());
    }

    public static enum MentionType {
        Found,
        Required,
        Allowed;

    }
}

