/*
 * Decompiled with CFR 0.152.
 */
package banner.types;

import banner.types.EntityName;
import banner.types.EntityType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Entity {
    private String id;
    private EntityType type;
    private Set<EntityName> names;

    public Entity(String id, EntityType type) {
        this.id = id;
        this.type = type;
        this.names = new HashSet<EntityName>();
    }

    public void addName(EntityName name) {
        if (!this.equals(name.getEntity())) {
            throw new IllegalArgumentException();
        }
        this.names.add(name);
    }

    public String getId() {
        return this.id;
    }

    public EntityType getEntityType() {
        return this.type;
    }

    public Set<EntityName> getNames() {
        return Collections.unmodifiableSet(this.names);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        Entity temp = (Entity)o;
        return this.id.equals(temp.getId());
    }

    public String toString() {
        return String.valueOf(this.type.toString()) + ": " + this.id;
    }
}

