/*
 * Decompiled with CFR 0.152.
 */
package banner.tagging.pipe;

import banner.types.Sentence;
import banner.types.Token;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.TokenSequence;
import java.util.List;
import java.util.Map;

public class TokenWeight
extends Pipe {
    private static final long serialVersionUID = 1L;
    private transient Map<String, Double> tokenWeights = null;

    public TokenWeight(Map<String, Double> tokenWeights) {
        this.tokenWeights = tokenWeights;
    }

    public void setTokenWeights(Map<String, Double> tokenWeights) {
        this.tokenWeights = tokenWeights;
    }

    @Override
    public Instance pipe(Instance carrier) {
        Sentence sentence = (Sentence)carrier.getSource();
        List<Token> tokens = sentence.getTokens();
        TokenSequence data2 = (TokenSequence)carrier.getData();
        int i = 0;
        while (i < tokens.size()) {
            Token bannerToken = tokens.get(i);
            String text2 = bannerToken.getText();
            cc.mallet.types.Token token2 = (cc.mallet.types.Token)data2.get(i);
            if (this.tokenWeights != null) {
                Double weight = this.tokenWeights.get(text2);
                if (weight == null) {
                    token2.setFeatureValue("TOKENWEIGHT=", 1.0);
                } else {
                    token2.setFeatureValue("TOKENWEIGHT=", weight);
                }
            }
            data2.add(token2);
            ++i;
        }
        return carrier;
    }
}

