/*
 * Decompiled with CFR 0.152.
 */
package banner.tagging.dictionary;

import banner.tagging.Tagger;
import banner.tokenization.Tokenizer;
import banner.types.EntityType;
import banner.types.Mention;
import banner.types.Sentence;
import banner.types.Token;
import banner.util.Trie;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;

public class DictionaryTagger
implements Tagger {
    private Tokenizer tokenizer;
    private boolean filterContainedMentions;
    protected Trie<String, Set<EntityType>> entities = new Trie();
    protected Trie<String, Boolean> notInclude = new Trie();
    private boolean normalizeMixedCase;
    private boolean normalizeDigits;
    private boolean generate2PartVariations;
    private boolean dropEndParentheticals;

    public void configure(HierarchicalConfiguration config, Tokenizer tokenizer) {
        SubnodeConfiguration localConfig = config.configurationAt(this.getClass().getName());
        this.filterContainedMentions = localConfig.getBoolean("filterContainedMentions", false);
        this.normalizeMixedCase = localConfig.getBoolean("normalizeMixedCase", false);
        this.normalizeDigits = localConfig.getBoolean("normalizeDigits", false);
        this.generate2PartVariations = localConfig.getBoolean("generate2PartVariations", false);
        this.dropEndParentheticals = localConfig.getBoolean("dropEndParentheticals", false);
        this.tokenizer = tokenizer;
    }

    public void load(HierarchicalConfiguration config) throws IOException {
        SubnodeConfiguration localConfig = config.configurationAt(this.getClass().getName());
        String dictionaryFilename = localConfig.getString("dictionaryFile");
        if (dictionaryFilename == null) {
            throw new IllegalArgumentException("Must specify dictionary filename");
        }
        String dictionaryTypeName = localConfig.getString("dictionaryType");
        if (dictionaryTypeName == null) {
            throw new IllegalArgumentException("Must specify dictionary type");
        }
        String delimiter = localConfig.getString("delimiter");
        int column = localConfig.getInt("column", -1);
        if (delimiter != null && column == -1) {
            throw new IllegalArgumentException("Must specify column if delimiter specified");
        }
        EntityType dictionaryType = EntityType.getType(dictionaryTypeName);
        BufferedReader reader = new BufferedReader(new FileReader(dictionaryFilename));
        String line = reader.readLine();
        while (line != null) {
            if ((line = line.trim()).length() > 0) {
                if (delimiter == null) {
                    this.add(line, dictionaryType);
                } else {
                    String[] split2 = line.split(delimiter);
                    this.add(split2[column], dictionaryType);
                }
            }
            line = reader.readLine();
        }
        reader.close();
    }

    protected List<String> process(String input2) {
        if (input2 == null) {
            throw new IllegalArgumentException();
        }
        List<String> tokens = this.tokenizer.getTokens(input2);
        int i = 0;
        while (i < tokens.size()) {
            tokens.set(i, this.transform(tokens.get(i)));
            ++i;
        }
        return tokens;
    }

    protected String transform(String str) {
        String result2 = str;
        if (this.normalizeMixedCase || this.normalizeDigits) {
            char[] chars = str.toCharArray();
            if (this.normalizeMixedCase) {
                boolean hasUpper = false;
                boolean hasLower = false;
                int i = 0;
                while (!(i >= chars.length || hasUpper && hasLower)) {
                    hasUpper |= Character.isUpperCase(chars[i]);
                    hasLower |= Character.isLowerCase(chars[i]);
                    ++i;
                }
                if (hasUpper && hasLower) {
                    i = 0;
                    while (i < chars.length) {
                        chars[i] = Character.toLowerCase(chars[i]);
                        ++i;
                    }
                }
            }
            if (this.normalizeDigits) {
                int i = 0;
                while (i < chars.length) {
                    if (Character.isDigit(chars[i])) {
                        chars[i] = 48;
                    }
                    ++i;
                }
            }
            result2 = new String(chars);
        }
        return result2;
    }

    public void add(String text2, EntityType type) {
        this.add(text2, Collections.singleton(type));
    }

    public void add(String text2, Collection<EntityType> types) {
        List<String> tokens = this.process(text2);
        this.add(tokens, types);
        if (this.generate2PartVariations) {
            if (tokens.size() == 1 && tokens.get(0).matches("[A-Za-z]+[0-9]+")) {
                int split2 = 0;
                String token2 = tokens.get(0);
                while (Character.isLetter(token2.charAt(split2))) {
                    ++split2;
                }
                this.add2Part(token2.substring(0, split2), token2.substring(split2, token2.length()), types);
            }
            if (tokens.size() == 2) {
                this.add2Part(tokens.get(0), tokens.get(1), types);
            }
            if (tokens.size() == 3 && (tokens.get(1).equals("-") || tokens.get(1).equals("/"))) {
                this.add2Part(tokens.get(0), tokens.get(2), types);
            }
        }
    }

    private void add2Part(String part1, String part2, Collection<EntityType> types) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(String.valueOf(part1) + part2);
        tokens.add(part2);
        this.add(tokens, types);
        tokens = new ArrayList();
        tokens.add(part1);
        tokens.add(part2);
        this.add(tokens, types);
        tokens.add(1, "-");
        this.add(tokens, types);
        tokens.set(1, "/");
        this.add(tokens, types);
    }

    public boolean add(List<String> tokens, Collection<EntityType> types) {
        Set<EntityType> currentTypes;
        if (tokens.size() == 0) {
            throw new IllegalArgumentException("Number of tokens must be greater than zero");
        }
        Boolean value2 = this.notInclude.getValue(tokens);
        if (value2 != null) {
            return false;
        }
        if (this.dropEndParentheticals && tokens.get(tokens.size() - 1).equals(")")) {
            int openParen = tokens.size() - 1;
            while (openParen > 0 && !tokens.get(openParen).equals("(")) {
                --openParen;
            }
            if (openParen <= 0) {
                return false;
            }
            tokens = tokens.subList(0, openParen);
        }
        if ((currentTypes = this.entities.getValue(tokens)) == null) {
            currentTypes = new HashSet<EntityType>(1);
            this.entities.add(tokens, currentTypes);
        }
        return currentTypes.addAll(types);
    }

    @Override
    public void tag(Sentence sentence) {
        List<Token> tokens = sentence.getTokens();
        LinkedList<Mention> mentions = new LinkedList<Mention>();
        int startIndex = 0;
        while (startIndex < tokens.size()) {
            Trie<String, Set<EntityType>> t = this.entities;
            int currentIndex = startIndex;
            while (currentIndex < tokens.size() && t != null) {
                Set<EntityType> entityTypes = t.getValue();
                if (entityTypes != null) {
                    for (EntityType entityType : entityTypes) {
                        mentions.add(new Mention(sentence, startIndex, currentIndex, entityType, Mention.MentionType.Found));
                    }
                }
                Token currentToken = tokens.get(currentIndex);
                t = t.getChild(this.transform(currentToken.getText()));
                ++currentIndex;
            }
            ++startIndex;
        }
        if (this.filterContainedMentions) {
            while (!mentions.isEmpty()) {
                Mention mention1 = (Mention)mentions.remove(0);
                int start = mention1.getStart();
                int end = mention1.getEnd();
                ArrayList<Mention> adjacentMentions = new ArrayList<Mention>();
                Iterator mentionIterator = mentions.iterator();
                boolean changed = true;
                while (changed) {
                    changed = false;
                    while (mentionIterator.hasNext()) {
                        boolean adjacent;
                        Mention mention2 = (Mention)mentionIterator.next();
                        boolean bl = adjacent = end >= mention2.getStart() && start <= mention2.getEnd();
                        if (!mention1.getEntityType().equals(mention2.getEntityType()) || !adjacent) continue;
                        adjacentMentions.add(mention2);
                        mentionIterator.remove();
                        start = Math.min(start, mention2.getStart());
                        end = Math.max(end, mention2.getEnd());
                        changed = true;
                    }
                }
                sentence.addMention(new Mention(sentence, start, end, mention1.getEntityType(), Mention.MentionType.Found));
            }
        } else {
            for (Mention mention : mentions) {
                sentence.addMention(mention);
            }
        }
    }

    public void suppress(String text2) {
        this.notInclude.add(this.process(text2), Boolean.TRUE);
    }

    public int size() {
        return this.entities.size();
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public void setTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public boolean isFilterContainedMentions() {
        return this.filterContainedMentions;
    }

    public void setFilterContainedMentions(boolean filterContainedMentions) {
        this.filterContainedMentions = filterContainedMentions;
    }

    public boolean isNormalizeMixedCase() {
        return this.normalizeMixedCase;
    }

    public void setNormalizeMixedCase(boolean normalizeMixedCase) {
        this.normalizeMixedCase = normalizeMixedCase;
    }

    public boolean isNormalizeDigits() {
        return this.normalizeDigits;
    }

    public void setNormalizeDigits(boolean normalizeDigits) {
        this.normalizeDigits = normalizeDigits;
    }

    public boolean isGenerate2PartVariations() {
        return this.generate2PartVariations;
    }

    public void setGenerate2PartVariations(boolean generate2PartVariations) {
        this.generate2PartVariations = generate2PartVariations;
    }

    public boolean isDropEndParentheticals() {
        return this.dropEndParentheticals;
    }

    public void setDropEndParentheticals(boolean dropEndParentheticals) {
        this.dropEndParentheticals = dropEndParentheticals;
    }
}

