/*
 * Decompiled with CFR 0.152.
 */
package banner.postprocessing;

import banner.postprocessing.ExtractAbbrev;
import banner.postprocessing.PostProcessor;
import banner.types.EntityType;
import banner.types.Mention;
import banner.types.Sentence;
import java.util.Set;

public class LocalAbbreviationPostProcessor
implements PostProcessor {
    private ExtractAbbrev extractAbbrev = new ExtractAbbrev();

    private void processAbbreviation(Mention formFound, String formNotFound) {
        int end;
        Sentence sentence = formFound.getSentence();
        EntityType type = formFound.getEntityType();
        int charIndex = sentence.getText().indexOf(formNotFound);
        int start = sentence.getTokenIndex(charIndex, true);
        if (start == (end = sentence.getTokenIndex(charIndex + formNotFound.length(), false))) {
            return;
        }
        Mention newMention = new Mention(sentence, start, end, type, formFound.getMentionType(), formFound.getProbability());
        boolean overlaps = false;
        for (Mention mention : sentence.getMentions()) {
            overlaps |= mention.overlaps(newMention);
        }
        if (!overlaps) {
            sentence.addMention(newMention);
        }
    }

    @Override
    public void postProcess(Sentence sentence) {
        Set<ExtractAbbrev.AbbreviationPair> abbreviationPairs = this.extractAbbrev.extractAbbrPairs(sentence.getText());
        if (abbreviationPairs.size() > 0) {
            for (ExtractAbbrev.AbbreviationPair abbreviation : abbreviationPairs) {
                Mention shortMention = null;
                Mention longMention = null;
                for (Mention mention : sentence.getMentions()) {
                    if (abbreviation.getShortForm().equals(mention.getText())) {
                        shortMention = mention;
                    }
                    if (!abbreviation.getLongForm().equals(mention.getText())) continue;
                    longMention = mention;
                }
                if (shortMention == null) {
                    if (longMention == null) continue;
                    this.processAbbreviation(longMention, abbreviation.getShortForm());
                    continue;
                }
                if (longMention != null) continue;
                this.processAbbreviation(shortMention, abbreviation.getLongForm());
            }
        }
    }
}

