/*
 * Decompiled with CFR 0.152.
 */
package banner.normalization;

public abstract class Metric
extends Enum<Metric> {
    public static final /* enum */ Metric Dice = new Metric(){

        @Override
        protected double similarityInternal(int intersection2, int size1, int size2) {
            return 2.0 * (double)intersection2 / (double)(size1 + size2);
        }
    };
    public static final /* enum */ Metric Jaccard = new Metric(){

        @Override
        protected double similarityInternal(int intersection2, int size1, int size2) {
            return (double)intersection2 / (double)(size1 + size2 - intersection2);
        }
    };
    public static final /* enum */ Metric Overlap = new Metric(){

        @Override
        protected double similarityInternal(int intersection2, int size1, int size2) {
            return (double)intersection2 / (double)Math.min(size1, size2);
        }
    };
    public static final /* enum */ Metric CosineTheta = new Metric(){

        @Override
        protected double similarityInternal(int intersection2, int size1, int size2) {
            return (double)(intersection2 * intersection2) / (double)(size1 * size2);
        }
    };
    private static final /* synthetic */ Metric[] ENUM$VALUES;

    static {
        ENUM$VALUES = new Metric[]{Dice, Jaccard, Overlap, CosineTheta};
    }

    private Metric() {
    }

    public double similarity(int intersection2, int size1, int size2) {
        if (intersection2 > Math.min(size1, size2)) {
            throw new IllegalArgumentException("Illegal arguments - intersection:" + intersection2 + ", size1:" + size1 + ", size2:" + size2);
        }
        double similarity = this.similarityInternal(intersection2, size1, size2);
        assert (similarity > 0.0);
        if (similarity > 1.0 && similarity < 1.000001) {
            similarity = 1.0;
        }
        assert (similarity <= 1.0);
        return similarity;
    }

    protected abstract double similarityInternal(int var1, int var2, int var3);

    public static Metric[] values() {
        Metric[] metricArray = ENUM$VALUES;
        int n = metricArray.length;
        Metric[] metricArray2 = new Metric[n];
        System.arraycopy(ENUM$VALUES, 0, metricArray2, 0, n);
        return metricArray2;
    }

    public static Metric valueOf(String string2) {
        return Enum.valueOf(Metric.class, string2);
    }

    /* synthetic */ Metric(String string2, int n, Metric metric) {
        this();
    }
}

