/*
 * Decompiled with CFR 0.152.
 */
package banner.normalization;

import banner.normalization.MentionDisambiguator;
import banner.types.EntityIdentification;
import banner.types.EntityName;
import banner.types.Mention;
import banner.types.Sentence;
import java.util.ArrayList;

public class BestMatchDisambiguator
implements MentionDisambiguator {
    private double threshold;

    public BestMatchDisambiguator(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public void disambiguateMentions(Sentence sentence) {
        ArrayList<Mention> mentions = new ArrayList<Mention>(sentence.getMentions());
        for (Mention mention : mentions) {
            if (this.disambiguate(mention)) continue;
            sentence.removeMention(mention);
        }
    }

    public boolean disambiguate(Mention mention) {
        Sentence sentence = mention.getSentence();
        EntityIdentification identification = sentence.getIdentification(mention);
        if (identification == null) {
            return false;
        }
        Double bestValue = identification.getBestValue();
        if (bestValue == null || bestValue <= this.threshold) {
            return false;
        }
        EntityIdentification disambiguated = new EntityIdentification(mention);
        for (EntityName name : identification.getNames()) {
            Double value2 = identification.getValue(name);
            if (!(value2 >= bestValue)) continue;
            disambiguated.set(name, value2);
        }
        sentence.setIdentification(mention, disambiguated);
        return true;
    }
}

