/*
 * Decompiled with CFR 0.152.
 */
package banner.annotation;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class BEAT
extends JFrame
implements ActionListener,
CaretListener {
    private String[] columnNames = new String[]{"Start", "End", "Text", "Action"};
    private JLabel progressLabel;
    private JLabel textFileLabel;
    private JTextField textFileField;
    private JButton textFileSetButton;
    private JLabel annotationFileLabel;
    private JTextField annotationFileField;
    private JButton annotationFileSetButton;
    private JFileChooser fileChooser;
    private JLabel identifierLabel;
    private JTextField identifierField;
    private JLabel textLabel;
    private JTextArea textArea;
    private JScrollPane textScroll;
    private JLabel anotationLabel;
    private JTable annotationTable;
    private JScrollPane annotationScroll;
    private JButton previousButton;
    private JButton nextButton;
    private int current = -1;
    private int selectionStart;
    private int selectionEnd;
    private List<String> ids = new ArrayList<String>();
    private Map<String, Text> texts = new HashMap<String, Text>();
    private Map<String, List<Annotation>> annotations = new HashMap<String, List<Annotation>>();

    public BEAT() {
        this.initComponents();
        this.initLayout();
        this.setTitle("Simple Annotation Tool");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent arg0) {
                System.exit(0);
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
                BEAT.this.saveAnnotation();
                BEAT.this.setVisible(false);
                BEAT.this.dispose();
            }
        });
        this.pack();
    }

    private void initComponents() {
        this.progressLabel = new JLabel("?/?");
        this.textFileLabel = new JLabel("Text file:");
        this.textFileField = new JTextField();
        this.textFileField.setEditable(false);
        this.textFileSetButton = new JButton("Set...");
        this.textFileSetButton.addActionListener(this);
        this.annotationFileLabel = new JLabel("Annotation file:");
        this.annotationFileField = new JTextField();
        this.annotationFileField.setEditable(false);
        this.annotationFileSetButton = new JButton("Set...");
        this.annotationFileSetButton.addActionListener(this);
        this.annotationFileSetButton.setEnabled(false);
        this.identifierLabel = new JLabel("Identifier:");
        this.identifierField = new JTextField();
        this.identifierField.setEditable(false);
        this.identifierField.setEnabled(false);
        this.textLabel = new JLabel("Text:");
        this.textArea = new JTextArea();
        this.textArea.setEnabled(false);
        this.textScroll = new JScrollPane(this.textArea);
        this.anotationLabel = new JLabel("Annotations:");
        this.annotationTable = new JTable(new AnnotationTableModel());
        this.annotationScroll = new JScrollPane(this.annotationTable);
        this.previousButton = new JButton("Previous");
        this.previousButton.setMnemonic(80);
        this.previousButton.addActionListener(this);
        this.previousButton.setEnabled(false);
        this.nextButton = new JButton("Next");
        this.nextButton.setMnemonic(78);
        this.nextButton.addActionListener(this);
        this.nextButton.setEnabled(false);
        this.fileChooser = new JFileChooser();
        this.textArea.addCaretListener(this);
        this.textArea.setColumns(30);
        this.textArea.setLineWrap(true);
        this.textArea.setRows(8);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEditable(false);
        Font defaultFont = this.textArea.getFont();
        Font newFont = new Font(defaultFont.getFontName(), 1, defaultFont.getSize() + 4);
        this.textArea.setFont(newFont);
        TableColumnModel columnModel = this.annotationTable.getColumnModel();
        columnModel.getColumn(3).setCellRenderer(new ButtonRenderer());
        columnModel.getColumn(3).setCellEditor(new ButtonEditor(this.annotationTable));
        this.annotationTable.setCellSelectionEnabled(true);
    }

    private void initLayout() {
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.ipadx = 5;
        c.ipady = 5;
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 22;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pane.add((Component)this.progressLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pane.add((Component)this.textFileLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        pane.add((Component)this.textFileField, c);
        c.gridx = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pane.add((Component)this.textFileSetButton, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pane.add((Component)this.annotationFileLabel, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        pane.add((Component)this.annotationFileField, c);
        c.gridx = 2;
        c.gridy = 2;
        c.gridwidth = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pane.add((Component)this.annotationFileSetButton, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pane.add((Component)this.identifierLabel, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 2;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        pane.add((Component)this.identifierField, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pane.add((Component)this.textLabel, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 4;
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.8;
        pane.add((Component)this.textScroll, c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 2;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pane.add((Component)this.anotationLabel, c);
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 4;
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.2;
        pane.add((Component)this.annotationScroll, c);
        c.gridx = 0;
        c.gridy = 8;
        c.gridwidth = 1;
        c.anchor = 21;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pane.add((Component)this.previousButton, c);
        c.gridx = 2;
        c.gridy = 8;
        c.gridwidth = 1;
        c.anchor = 22;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pane.add((Component)this.nextButton, c);
        this.getContentPane().add((Component)pane, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.nextButton) {
            System.out.println("Pressed nextButton");
            this.saveAnnotation();
            ++this.current;
            this.update();
        } else if (event.getSource() == this.textFileSetButton) {
            System.out.println("Pressed textFileSetButton");
            String updated2 = this.chooseFile(this.textFileField.getText());
            if (updated2 != null && this.loadTexts(updated2)) {
                this.textFileField.setText(updated2);
                this.textFileSetButton.setEnabled(false);
                this.annotationFileSetButton.setEnabled(true);
            }
        } else if (event.getSource() == this.annotationFileSetButton) {
            System.out.println("Pressed annotationFileSetButton");
            String updated3 = this.chooseFile(this.annotationFileField.getText());
            if (updated3 != null && this.loadAnnotations(updated3) && this.ids.size() > 0) {
                this.annotationFileField.setText(updated3);
                this.annotationFileSetButton.setEnabled(false);
                this.identifierField.setEnabled(true);
                this.textArea.setEnabled(true);
                this.annotationTable.setEnabled(true);
                this.previousButton.setEnabled(true);
                this.nextButton.setEnabled(true);
                this.current = 0;
                this.update();
            }
        } else if (event.getSource() == this.previousButton) {
            System.out.println("Pressed previousButton");
            this.saveAnnotation();
            --this.current;
            this.update();
        }
    }

    @Override
    public void caretUpdate(CaretEvent arg0) {
        int start = this.textArea.getSelectionStart();
        int end = this.textArea.getSelectionEnd();
        if (end <= start) {
            this.selectionStart = -1;
            this.selectionEnd = -1;
            return;
        }
        String text2 = this.textArea.getSelectedText().trim();
        if (text2.length() == 0) {
            this.selectionStart = -1;
            this.selectionEnd = -1;
            return;
        }
        System.out.println("Selected: " + start + " - " + end + " = " + text2);
        this.selectionStart = start;
        this.selectionEnd = end;
        ((AnnotationTableModel)this.annotationTable.getModel()).fireTableDataChanged();
    }

    private String chooseFile(String current) {
        File currentFile = null;
        if (current != null) {
            currentFile = new File(current);
        }
        this.fileChooser.setCurrentDirectory(currentFile);
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            String path;
            File file = this.fileChooser.getSelectedFile();
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            System.out.println("Opening text file: " + path + ".");
            return path;
        }
        System.out.println("Open command cancelled by user.");
        return null;
    }

    private boolean loadTexts(String filename) {
        System.out.println("Loading texts");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0) {
                    String[] split2 = line.split("\\t");
                    if (split2.length != 2) {
                        throw new RuntimeException("Text file is in wrong format");
                    }
                    Text text2 = new Text(split2[0], split2[1]);
                    if (this.texts.containsKey(text2.getId())) {
                        throw new RuntimeException("Duplicate identifier in text file: " + text2.getId());
                    }
                    this.ids.add(text2.getId());
                    this.texts.put(text2.getId(), text2);
                    if (!this.annotations.containsKey(text2.getId())) {
                        this.annotations.put(text2.getId(), new ArrayList());
                    }
                }
                line = reader.readLine();
            }
            Collections.sort(this.ids);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean loadAnnotations(String filename) {
        System.out.println("Loading annotations");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0) {
                    String[] split2 = line.split("\\t");
                    if (split2.length != 4) {
                        throw new RuntimeException("Annotation file is in wrong format");
                    }
                    Annotation annotation = new Annotation(split2[0], Integer.parseInt(split2[1]), Integer.parseInt(split2[2]));
                    Text text2 = this.texts.get(annotation.getId());
                    if (text2 == null) {
                        throw new RuntimeException("Texts does not contain identifier: " + annotation.getId());
                    }
                    if (!split2[3].equals(text2.getText().substring(annotation.getStart(), annotation.getEnd()))) {
                        throw new RuntimeException("Annotation text does not match: " + annotation.getId());
                    }
                    this.annotations.get(annotation.getId()).add(annotation);
                }
                line = reader.readLine();
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void saveAnnotation() {
        String filename = this.annotationFileField.getText();
        if (filename == null) {
            return;
        }
        if ((filename = filename.trim()).length() == 0) {
            return;
        }
        System.out.println("Saving annotations");
        try {
            PrintWriter writer = new PrintWriter(filename);
            for (String id : this.ids) {
                Text text2 = this.texts.get(id);
                for (Annotation annotation : this.annotations.get(id)) {
                    StringBuilder line = new StringBuilder();
                    line.append(annotation.getId());
                    line.append("\t");
                    line.append(annotation.getStart());
                    line.append("\t");
                    line.append(annotation.getEnd());
                    line.append("\t");
                    line.append(text2.getText().substring(annotation.getStart(), annotation.getEnd()));
                    writer.println(line);
                }
            }
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void update() {
        if (this.current < 0) {
            this.current = this.ids.size() - 1;
        }
        this.current %= this.ids.size();
        this.progressLabel.setText(this.current + 1 + "/" + this.ids.size());
        String id = this.ids.get(this.current);
        Text text2 = this.texts.get(id);
        this.identifierField.setText(text2.getId());
        this.textArea.setText(text2.getText());
        ((AnnotationTableModel)this.annotationTable.getModel()).fireTableDataChanged();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                new BEAT().setVisible(true);
            }
        });
    }

    private class Annotation
    implements Comparable<Annotation> {
        private String id;
        private int start;
        private int end;

        public Annotation(String id, int start, int end) {
            this.id = id;
            this.start = start;
            this.end = end;
        }

        public String getId() {
            return this.id;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        @Override
        public int compareTo(Annotation annotation2) {
            int cmp = this.start - annotation2.start;
            if (cmp != 0) {
                return cmp;
            }
            return this.end - annotation2.end;
        }
    }

    private class AnnotationTableModel
    extends AbstractTableModel {
        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 3) {
                return rowIndex == 0 ? "Add" : "Remove";
            }
            if (BEAT.this.current == -1) {
                return null;
            }
            if (rowIndex == 0) {
                if (BEAT.this.selectionStart == -1 || BEAT.this.selectionEnd == -1) {
                    return null;
                }
                String id = (String)BEAT.this.ids.get(BEAT.this.current);
                Text text2 = (Text)BEAT.this.texts.get(id);
                switch (columnIndex) {
                    case 0: {
                        return BEAT.this.selectionStart;
                    }
                    case 1: {
                        return BEAT.this.selectionEnd;
                    }
                    case 2: {
                        return text2.getText().substring(BEAT.this.selectionStart, BEAT.this.selectionEnd);
                    }
                }
                throw new IllegalArgumentException();
            }
            List annotationList = (List)BEAT.this.annotations.get(BEAT.this.ids.get(BEAT.this.current));
            Annotation annotation = (Annotation)annotationList.get(rowIndex - 1);
            int start = annotation.getStart();
            int end = annotation.getEnd();
            String id = (String)BEAT.this.ids.get(BEAT.this.current);
            Text text3 = (Text)BEAT.this.texts.get(id);
            switch (columnIndex) {
                case 0: {
                    return start;
                }
                case 1: {
                    return end;
                }
                case 2: {
                    return text3.getText().substring(start, end);
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public int getRowCount() {
            if (BEAT.this.current == -1) {
                return 0;
            }
            String id = (String)BEAT.this.ids.get(BEAT.this.current);
            return ((List)BEAT.this.annotations.get(id)).size() + 1;
        }

        @Override
        public String getColumnName(int col) {
            return BEAT.this.columnNames[col];
        }

        @Override
        public int getColumnCount() {
            return BEAT.this.columnNames.length;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3;
        }
    }

    private class ButtonEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JTable table;
        JButton button = new JButton();
        int clickCountToStart = 1;

        public ButtonEditor(JTable table) {
            this.table = table;
            this.button.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = this.table.getEditingRow();
            int column = this.table.getEditingColumn();
            System.out.printf("row = %d  col = %d%n", row, column);
            boolean update2 = false;
            if (column == 3) {
                String id = (String)BEAT.this.ids.get(BEAT.this.current);
                List annotationList = (List)BEAT.this.annotations.get(id);
                if (row == 0) {
                    if (BEAT.this.selectionStart != -1 && BEAT.this.selectionEnd != -1) {
                        annotationList.add(new Annotation(id, BEAT.this.selectionStart, BEAT.this.selectionEnd));
                        Collections.sort(annotationList);
                        update2 = true;
                    }
                } else {
                    annotationList.remove(row - 1);
                    update2 = true;
                }
            }
            this.stopCellEditing();
            if (update2) {
                BEAT.this.update();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
            this.button.setText(value2.toString());
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return this.button.getText();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
            }
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
        }
    }

    private class ButtonRenderer
    implements TableCellRenderer {
        JButton button = new JButton();

        private ButtonRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            this.button.setText(value2.toString());
            return this.button;
        }
    }

    private class Text {
        private String id;
        private String text;

        public Text(String id, String text2) {
            this.id = id;
            this.text = text2;
        }

        public String getId() {
            return this.id;
        }

        public String getText() {
            return this.text;
        }
    }
}

