/*
 * Customer.cpp
 *
 *  Created on: 02.12.2009
 *      Author: ingmar
 */

#include "Customer.h"

Customer::Customer(AgencySimulation& sim):
	odemx::base::Process(sim,"Customer"), sim(sim), clerk(NULL) {
}

Customer::~Customer() {
	std::cerr << "got deleted" << std::endl;
}

int Customer::main() {

	startTime = sim.getTime();

	//if the queue is to long leave immediately
	if (sim.getCounterWaitQ()->getWaitingSlaves().size() > 10) {
		sim.getUnsatisfiedCount()->update(1);
		return 0;
	}

	//arrived at agency, wait for clerk
	sim.getCounterWaitQ()->wait();

	//got served, now fill out the form
	holdFor(2);

	//enter the queue again to hand over filled form to THE SAME CLERK
	sim.getCounterWaitQ()->wait();

	endTime = sim.getTime();
	//enter the serviced customer list
	sim.getServiceTimeTally()->update(calculateServiceTime());

	//i am done
	return 0;
}

double Customer::calculateServiceTime() {
	return endTime - startTime;
}
