/*
 * Barber.h
 *
 *  Created on: 02.12.2009
 *      Author: ingmar
 */

#ifndef BARBER_H_
#define BARBER_H_

#include <odemx/odemx.h>
#include <list>

#include "Customer.h"

class Clerk: public odemx::base::Process {
public:
	Clerk(
			AgencySimulation& sim,
			double expectedValue,
			double variance
	);
	virtual ~Clerk();

	int main();

	//selection method
	bool suitableCustomer (odemx::base::Process* partner);

	//selection method
	bool onlyMyCustomer (odemx::base::Process* partner);

	//weight method
	double bestCustomer ( Process* partner );

private:

	AgencySimulation& sim;
	double expectedValue;
	double variance;

	odemx::random::ContinuousDist* random;
};

#endif /* BARBER_H_ */
